/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.samplers.MemorySampler;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.samplers.SamplerService;
import com.newrelic.agent.samplers.ThreadSampler;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.MergeStatsEngine;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SamplerServiceImpl
extends AbstractService
implements SamplerService {
    private static final String SAMPLER_THREAD_NAME = "New Relic Sampler Service";
    private static final long INITIAL_DELAY_IN_MILLISECONDS = 1000L;
    private static final long DELAY_IN_MILLISECONDS = 5000L;
    private final ScheduledExecutorService scheduledExecutor;
    private final List<ScheduledFuture<?>> tasks = new CopyOnWriteArrayList();
    private final StatsEngine statsEngine = new StatsEngineImpl();
    private final IAgent agent;
    private final String defaultAppName;
    private final boolean isAutoAppNamingEnabled;

    public SamplerServiceImpl() {
        super(SamplerService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(SAMPLER_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.agent = ServiceFactory.getAgent();
        IAgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.isAutoAppNamingEnabled = config.isAutoAppNamingEnabled();
        this.defaultAppName = config.getApplicationName();
    }

    protected void doStart() {
        MemorySampler memorySampler = new MemorySampler();
        memorySampler.start();
        this.addMetricSampler(memorySampler, 1000L, 5000L, TimeUnit.MILLISECONDS);
        ThreadSampler threadSampler = new ThreadSampler();
        this.addMetricSampler(threadSampler, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        for (ScheduledFuture<?> task : this.tasks) {
            task.cancel(false);
        }
        this.scheduledExecutor.shutdown();
    }

    public boolean isEnabled() {
        return true;
    }

    public void addMetricSampler(final MetricSampler sampler, long initialDelay, long delay, TimeUnit unit) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SamplerServiceImpl.this.runSampler(sampler);
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Unable to sample {0}: {1}", this.getClass().getName(), t);
                    if (SamplerServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                        SamplerServiceImpl.this.getLogger().log(Level.WARNING, msg, t);
                    } else {
                        SamplerServiceImpl.this.getLogger().warning(msg);
                    }
                }
                finally {
                    SamplerServiceImpl.this.statsEngine.clear();
                }
            }
        };
        ScheduledFuture<?> task = this.scheduledExecutor.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
        this.tasks.add(task);
    }

    private void runSampler(MetricSampler sampler) {
        if (!this.agent.isEnabled()) {
            return;
        }
        sampler.sample(this.statsEngine);
        if (!this.isAutoAppNamingEnabled) {
            this.mergeStatsEngine(this.defaultAppName);
            return;
        }
        List<IRPMService> rpmServices = ServiceFactory.getRPMServiceManager().getRPMServices();
        for (IRPMService rpmService : rpmServices) {
            String appName = rpmService.getApplicationName();
            this.mergeStatsEngine(appName);
        }
    }

    private void mergeStatsEngine(String appName) {
        StatsService statsService = ServiceFactory.getStatsService();
        MergeStatsEngine work = new MergeStatsEngine(appName, this.statsEngine);
        statsService.doStatsWork(work);
    }
}

