/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.AbstractCommand;
import com.newrelic.agent.commands.CommandException;
import com.newrelic.agent.profile.ProfilerControl;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.util.TimeConversion;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartProfilerCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "start_profiler";
    private static final String DISABLED_MESSAGE = "The profiler service is disabled";
    private final ProfilerControl profilerControl;

    public StartProfilerCommand(ProfilerControl profilerControl) {
        super(COMMAND_NAME);
        this.profilerControl = profilerControl;
    }

    @Override
    public Map<?, ?> process(IRPMService rpmService, Map arguments) throws CommandException {
        if (this.profilerControl.isEnabled()) {
            return this.processEnabled(rpmService, arguments);
        }
        return this.processDisabled(rpmService, arguments);
    }

    public Map<?, ?> processEnabled(IRPMService rpmService, Map<?, ?> arguments) throws CommandException {
        long durationLong;
        long samplePeriodLong;
        if (arguments.size() < 3) {
            throw new CommandException("The start_profiler command expected 3 arguments");
        }
        Object duration = arguments.remove("duration");
        Object period = arguments.remove("sample_period");
        Object profileId = arguments.remove("profile_id");
        Object onlyRunnables = arguments.remove("only_runnable_threads");
        Object breakoutByUrl = arguments.remove("breakout_by_url");
        Object profileAgentCodeValue = arguments.remove("profile_agent_code");
        Object web_transactions = arguments.remove("web_transactions");
        if (!(duration instanceof Number)) {
            throw new CommandException("The start_profiler command encountered an invalid duration: " + duration);
        }
        if (!(period instanceof Number)) {
            throw new CommandException("The start_profiler command encountered an invalid period: " + period);
        }
        if (!(profileId instanceof Number)) {
            throw new CommandException("The start_profiler command encountered an invalid profile id: " + profileId);
        }
        boolean profileAgentThreads = Agent.isDebugEnabled();
        if (profileAgentCodeValue != null) {
            profileAgentThreads = profileAgentCodeValue instanceof Boolean && (Boolean)profileAgentCodeValue != false;
        }
        List webTransactions = Collections.emptyList();
        if (web_transactions instanceof List) {
            webTransactions = (List)web_transactions;
        }
        if ((samplePeriodLong = TimeConversion.convertSecondsToMillis(((Number)period).doubleValue())) > (durationLong = TimeConversion.convertSecondsToMillis(((Number)duration).doubleValue()))) {
            throw new CommandException(MessageFormat.format("The start_profiler command requires the sample period to be less than the duration.  Sample period : {0}, duration : {1}", period, duration));
        }
        arguments.remove("only_request_threads");
        if (arguments.size() > 0) {
            Agent.LOG.warning(MessageFormat.format("The start profiler command didn''t recognize the following arguments: {0}", arguments.keySet().toString()));
        }
        ProfilerParameters parameters = new ProfilerParameters(((Number)profileId).longValue(), onlyRunnables != null && (Boolean)onlyRunnables != false, breakoutByUrl != null && (Boolean)breakoutByUrl != false, profileAgentThreads, webTransactions);
        this.profilerControl.startProfiler(parameters, samplePeriodLong, durationLong);
        return Collections.EMPTY_MAP;
    }

    public Map<?, ?> processDisabled(IRPMService rpmService, Map<?, ?> arguments) throws CommandException {
        Agent.LOG.log(Level.INFO, DISABLED_MESSAGE);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("error", DISABLED_MESSAGE);
        return map;
    }
}

