/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.normalization.NormalizationRule;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.normalization.RuleResult;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizerImpl
implements Normalizer {
    private final List<NormalizationRule> rules;
    private final String appName;

    public NormalizerImpl(String appName, List<NormalizationRule> rules) {
        this.appName = appName;
        this.rules = Collections.unmodifiableList(rules);
    }

    @Override
    public String normalize(String name) {
        String normalizedName = name;
        for (NormalizationRule rule : this.rules) {
            RuleResult result = rule.normalize(normalizedName);
            if (!result.isMatch()) continue;
            if (rule.isIgnore()) {
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String msg = MessageFormat.format("Ignoring \"{0}\" for \"{1}\" because it matched rule \"{2}\"", name, this.appName, rule);
                    Agent.LOG.finer(msg);
                }
                return null;
            }
            String replacement = result.getReplacement();
            if (replacement != null) {
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String msg = MessageFormat.format("Normalized \"{0}\" to \"{2}\" for \"{1}\" using rule \"{3}\"", name, this.appName, replacement, rule);
                    Agent.LOG.finer(msg);
                }
                normalizedName = replacement;
            }
            if (!rule.isTerminateChain()) continue;
            break;
        }
        return normalizedName;
    }

    @Override
    public List<NormalizationRule> getRules() {
        return this.rules;
    }
}

