/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.normalization.NormalizationRule;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.normalization.NormalizerImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizerFactory {
    public static Normalizer createUrlNormalizer(String appName, List<NormalizationRule> urlRules) {
        return new UrlNormalizer(new NormalizerImpl(appName, urlRules));
    }

    public static Normalizer createTransactionNormalizer(String appName, List<NormalizationRule> transactionNameRules) {
        return new NormalizerImpl(appName, transactionNameRules);
    }

    public static Normalizer createMetricNormalizer(String appName, List<NormalizationRule> metricNameRules) {
        return new NormalizerImpl(appName, metricNameRules);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlNormalizer
    implements Normalizer {
        private final Normalizer normalizer;

        private UrlNormalizer(Normalizer normalizer) {
            this.normalizer = normalizer;
        }

        @Override
        public String normalize(String name) {
            String normalizedName = name;
            if (!normalizedName.startsWith("/")) {
                normalizedName = "/" + name;
            }
            return this.normalizer.normalize(normalizedName);
        }

        @Override
        public List<NormalizationRule> getRules() {
            return this.normalizer.getRules();
        }
    }
}

