/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.logging.IAgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.LogFileHelper;
import com.newrelic.agent.logging.LogbackLogger;
import com.newrelic.ch.qos.logback.classic.Level;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;

public class LogbackLogManager
implements IAgentLogManager {
    private static final String CONFIG_FILE_PROP = "logback.configurationFile";
    private final LogbackLogger rootLogger;
    private volatile String logFilePath;

    private LogbackLogManager(String name) {
        this.rootLogger = this.initializeRootLogger(name);
        this.rootLogger.info("Agent is using Logback");
    }

    private LogbackLogger createRootLogger(String name) {
        LogbackLogger logger = LogbackLogger.create(name, true);
        logger.setLevel(Level.INFO.levelStr.toLowerCase());
        logger.addConsoleAppender();
        return logger;
    }

    private LogbackLogger initializeRootLogger(String name) {
        LogbackLogger logger = null;
        try {
            URL jarUrl = AgentJarHelper.getAgentJarUrl();
            if (jarUrl == null) {
                logger = LogbackLogger.create(name, true);
            } else {
                String old = System.getProperty(CONFIG_FILE_PROP);
                System.setProperty(CONFIG_FILE_PROP, jarUrl.getFile());
                logger = this.createRootLogger(name);
                if (old == null) {
                    System.getProperties().remove(CONFIG_FILE_PROP);
                } else {
                    System.setProperty(CONFIG_FILE_PROP, old);
                }
            }
        }
        catch (Exception e) {
            if (logger == null) {
                logger = this.createRootLogger(name);
            }
            String msg = MessageFormat.format("Error setting logback.configurationFile property: {0}", e);
            logger.warning(msg);
        }
        return logger;
    }

    public IAgentLogger getRootLogger() {
        return this.rootLogger;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void configureLogger(IAgentConfig pAgentConfig) {
        this.configureLogLevel(pAgentConfig);
        this.configureConsoleHandler(pAgentConfig);
        this.configureFileHandler(pAgentConfig);
    }

    private void configureFileHandler(IAgentConfig agentConfig) {
        String logFileName = this.getLogFileName(agentConfig);
        if (logFileName == null) {
            return;
        }
        try {
            this.configureFileHandler(logFileName, agentConfig);
            this.logFilePath = logFileName;
            String msg = MessageFormat.format("Writing to New Relic log file: {0}", logFileName);
            this.rootLogger.info(msg);
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Unable to configure newrelic log file: {0}", logFileName);
            this.rootLogger.error(msg);
            this.addConsoleHandler();
        }
    }

    private String getLogFileName(IAgentConfig agentConfig) {
        File logFile = LogFileHelper.getLogFile(agentConfig);
        return logFile == null ? null : logFile.getPath();
    }

    private void configureLogLevel(IAgentConfig agentConfig) {
        if (agentConfig.isDebugEnabled()) {
            this.rootLogger.setLevel(Level.TRACE.levelStr.toLowerCase());
        } else {
            this.rootLogger.setLevel(agentConfig.getLogLevel());
        }
    }

    private void configureConsoleHandler(IAgentConfig agentConfig) {
        if (agentConfig.isDebugEnabled() || agentConfig.isLoggingToStdOut()) {
            this.addConsoleHandler();
        } else {
            this.rootLogger.removeConsoleAppender();
        }
    }

    private String configureFileHandler(String logFileName, IAgentConfig agentConfig) throws IOException {
        int limit = agentConfig.getLogLimit() * 1024;
        int fileCount = Math.max(1, agentConfig.getLogFileCount());
        boolean isDaily = agentConfig.isLogDaily();
        this.rootLogger.addFileAppender(logFileName, limit, fileCount, isDaily);
        return logFileName;
    }

    public void addConsoleHandler() {
        this.rootLogger.addConsoleAppender();
    }

    public void setLogLevel(String pLevel) {
        this.rootLogger.setLevel(pLevel);
    }

    public String getLogLevel() {
        return this.rootLogger.getLevel();
    }

    public static LogbackLogManager create(String name) {
        return new LogbackLogManager(name);
    }
}

