/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.logging.CustomLevel;
import com.newrelic.agent.logging.CustomPatternLayout;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.Log4jLevelHelper;
import com.newrelic.org.apache.log4j.ConsoleAppender;
import com.newrelic.org.apache.log4j.DailyRollingFileAppender;
import com.newrelic.org.apache.log4j.FileAppender;
import com.newrelic.org.apache.log4j.Layout;
import com.newrelic.org.apache.log4j.Logger;
import com.newrelic.org.apache.log4j.RollingFileAppender;
import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Log4jLogger
implements IAgentLogger {
    private static final Pattern INPUT_PATTERN = Pattern.compile("\\{\\}");
    private static final String CONSOLE_APPENDER_NAME = "Console";
    private static final String FILE_APPENDER_NAME = "File";
    private static final boolean APPEND_TO_FILE = true;
    private static final boolean BUFFER_IO = false;
    private static final int BUFFER_SIZE = 1024;
    private static final String CONVERSION_PATTERN = "%d{MMM d, yyyy HH:mm:ss ZZZZ} NewRelic %i %p: %m%n";
    private static final String SYSTEM_OUT = "System.out";
    private final Logger logger;

    private Log4jLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    Logger getLogger() {
        return this.logger;
    }

    @Override
    public void error(String message) {
        this.logger.error(message);
    }

    @Override
    public void severe(String message) {
        this.logger.error(message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(message);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void config(String message) {
        this.logger.info(message);
    }

    @Override
    public void fine(String message) {
        this.logger.log(CustomLevel.FINE, message);
    }

    @Override
    public void finer(String message) {
        this.logger.log(CustomLevel.FINER, message);
    }

    @Override
    public void finest(String message) {
        this.logger.log(CustomLevel.FINEST, message);
    }

    @Override
    public void debug(String message) {
        this.logger.debug(message);
    }

    @Override
    public void trace(String message) {
        this.logger.trace(message);
    }

    @Override
    public boolean isFineEnabled() {
        return this.logger.isEnabledFor(CustomLevel.FINE);
    }

    @Override
    public boolean isFinerEnabled() {
        return this.logger.isEnabledFor(CustomLevel.FINER);
    }

    @Override
    public boolean isFinestEnabled() {
        return this.logger.isEnabledFor(CustomLevel.FINEST);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isLoggable(Level level) {
        com.newrelic.org.apache.log4j.Level log4jLevel = Log4jLevelHelper.getLevel(level);
        return this.logger.isEnabledFor(log4jLevel);
    }

    @Override
    public void log(Level level, String message, Throwable throwable) {
        com.newrelic.org.apache.log4j.Level log4jLevel = Log4jLevelHelper.getLevel(level);
        this.logger.log(log4jLevel, message, throwable);
    }

    @Override
    public void log(Level level, String message) {
        com.newrelic.org.apache.log4j.Level log4jLevel = Log4jLevelHelper.getLevel(level);
        this.logger.log(log4jLevel, message);
    }

    @Override
    public void log(Level pLevel, String pMessage, Object[] pArgs, Throwable pThrowable) {
        com.newrelic.org.apache.log4j.Level log4jLevel = Log4jLevelHelper.getLevel(pLevel);
        if (this.isLoggable(pLevel)) {
            StringBuilder output = new StringBuilder();
            Matcher m = INPUT_PATTERN.matcher(pMessage);
            int index = 0;
            int matchIndex = 0;
            int argSize = pArgs.length;
            while (m.find()) {
                output.append(pMessage.substring(index, m.start()));
                index = m.end();
                if (matchIndex >= argSize) continue;
                output.append(pArgs[matchIndex]);
                ++matchIndex;
            }
            output.append(pMessage.substring(index));
            this.logger.log(log4jLevel, output.toString(), pThrowable);
        }
    }

    @Override
    public IAgentLogger getChildLogger(Class<?> clazz) {
        return this.getChildLogger(clazz.getName(), clazz.getSimpleName());
    }

    @Override
    public IAgentLogger getChildLogger(String fullName, String simpleName) {
        return Log4jLogger.create(fullName);
    }

    public void setLevel(com.newrelic.org.apache.log4j.Level level) {
        this.logger.setLevel(level);
    }

    public com.newrelic.org.apache.log4j.Level getLevel() {
        return this.logger.getLevel();
    }

    public void removeConsoleAppender() {
        this.logger.removeAppender(CONSOLE_APPENDER_NAME);
    }

    public void addConsoleAppender() {
        if (this.logger.getAppender(CONSOLE_APPENDER_NAME) != null) {
            return;
        }
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setName(CONSOLE_APPENDER_NAME);
        consoleAppender.setLayout(this.createLayout());
        consoleAppender.setTarget(SYSTEM_OUT);
        consoleAppender.activateOptions();
        this.logger.addAppender(consoleAppender);
    }

    public void addFileAppender(String fileName, long logLimit, int fileCount, boolean isDaily) throws IOException {
        if (this.logger.getAppender(FILE_APPENDER_NAME) != null) {
            return;
        }
        FileAppender fileAppender = this.createFileAppender(fileCount, logLimit, isDaily, fileName);
        fileAppender.setName(FILE_APPENDER_NAME);
        this.logger.addAppender(fileAppender);
    }

    private FileAppender createDailyAppender(String fileName) throws IOException {
        DailyRollingFileAppender fileAppender = new DailyRollingFileAppender();
        fileAppender.setFile(fileName, true, false, 1024);
        fileAppender.setLayout(this.createLayout());
        fileAppender.setDatePattern("'.'yyyy-MM-dd");
        fileAppender.activateOptions();
        return fileAppender;
    }

    private FileAppender createFileAppender(int fileCount, long logLimit, boolean isDaily, String fileName) throws IOException {
        if (isDaily) {
            return this.createDailyAppender(fileName);
        }
        if (fileCount <= 1) {
            FileAppender appender = new FileAppender();
            appender.setFile(fileName, true, false, 1024);
            appender.setLayout(this.createLayout());
            return appender;
        }
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setMaxBackupIndex(fileCount);
        fileAppender.setMaximumFileSize(logLimit);
        fileAppender.setFile(fileName, true, false, 1024);
        fileAppender.setLayout(this.createLayout());
        return fileAppender;
    }

    private Layout createLayout() {
        return new CustomPatternLayout(CONVERSION_PATTERN);
    }

    public static Log4jLogger create(String name) {
        return new Log4jLogger(name);
    }
}

