/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.logging.LogbackMarkers;
import com.newrelic.ch.qos.logback.classic.spi.ILoggingEvent;
import com.newrelic.ch.qos.logback.core.filter.Filter;
import com.newrelic.ch.qos.logback.core.spi.FilterReply;
import com.newrelic.org.slf4j.Marker;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FineFilter
extends Filter<ILoggingEvent> {
    private Level javaLevel;
    private final Marker markerToMatch = LogbackMarkers.FINE_MARKER;
    private final Marker markerToFail = LogbackMarkers.FINER_MARKER;

    public FineFilter() {
        this.javaLevel = Level.INFO;
    }

    @Override
    public FilterReply decide(ILoggingEvent pEvent) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (Level.FINE.equals(this.javaLevel)) {
            Marker marker = pEvent.getMarker();
            if (marker == null) {
                return FilterReply.NEUTRAL;
            }
            if (marker.contains(this.markerToMatch)) {
                return FilterReply.ACCEPT;
            }
            if (marker.contains(this.markerToFail)) {
                return FilterReply.DENY;
            }
        }
        return FilterReply.NEUTRAL;
    }

    public boolean isEnabledFor(Level pLevel) {
        return this.javaLevel.intValue() <= pLevel.intValue();
    }

    public void setLevel(Level level) {
        this.javaLevel = level;
    }

    public Level getLevel() {
        return this.javaLevel;
    }

    @Override
    public void start() {
        if (this.javaLevel != null) {
            super.start();
        }
    }
}

