/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.ibm.websphere.management.statistics.BoundaryStatistic;
import com.ibm.websphere.management.statistics.CountStatistic;
import com.ibm.websphere.management.statistics.RangeStatistic;
import com.ibm.websphere.management.statistics.Statistic;
import com.ibm.websphere.management.statistics.Stats;
import com.ibm.websphere.management.statistics.TimeStatistic;
import com.newrelic.agent.jmx.AbstractStatsAttributeProcessor;
import com.newrelic.agent.stats.StatsEngine;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.ObjectInstance;

public class WebSphereStatsAttributeProcessor
extends AbstractStatsAttributeProcessor {
    public boolean process(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String metricName) {
        Object value = attribute.getValue();
        if (value instanceof Stats) {
            Stats jmxStats = (Stats)value;
            for (Statistic statistic : jmxStats.getStatistics()) {
                WebSphereStatsAttributeProcessor.processStatistic(statsEngine, instance, attribute, metricName, statistic);
            }
            return true;
        }
        return false;
    }

    static void processStatistic(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String metricName, Statistic statistic) {
        String fullMetricName = metricName + '/' + statistic.getName();
        if (statistic instanceof CountStatistic) {
            CountStatistic stat = (CountStatistic)statistic;
            statsEngine.getStats(fullMetricName).setCallCount((int)stat.getCount());
        } else if (statistic instanceof RangeStatistic) {
            RangeStatistic stat = (RangeStatistic)statistic;
            statsEngine.getStats(fullMetricName).recordDataPoint(stat.getCurrent());
        } else if (statistic instanceof BoundaryStatistic) {
            BoundaryStatistic stat = (BoundaryStatistic)statistic;
            statsEngine.getStats(fullMetricName).recordDataPoint(stat.getLowerBound());
            statsEngine.getStats(fullMetricName).recordDataPoint(stat.getUpperBound());
        } else if (statistic instanceof TimeStatistic) {
            TimeStatistic stat = (TimeStatistic)statistic;
            TimeUnit unit = WebSphereStatsAttributeProcessor.getTimeUnit(stat.getUnit());
            statsEngine.getResponseTimeStats(fullMetricName).recordResponseTime((int)stat.getCount(), stat.getTotalTime(), stat.getMinTime(), stat.getMaxTime(), unit);
        }
    }
}

