/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.jmx.JmxAttributeProcessor;
import com.newrelic.agent.jmx.JmxAttributeProcessorWrapper;
import com.newrelic.agent.jmx.JmxConfigFactory;
import com.newrelic.agent.jmx.JmxMetric;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxService
extends AbstractService
implements HarvestListener {
    private static final String J2EE_STATS_ATTRIBUTE_PROCESSOR_CLASS_NAME = "com.newrelic.agent.jmx.J2EEStatsAttributeProcessor";
    private static final String WEBSPHERE_STATS_ATTRIBUTE_PROCESSOR_CLASS_NAME = "com.newrelic.agent.jmx.WebSphereStatsAttributeProcessor";
    private final List<JmxConfigFactory.JmxConfig> configs = new ArrayList<JmxConfigFactory.JmxConfig>();
    private final boolean enabled;
    private final JmxConfigFactory jmxConfigFactory;
    private final boolean createMBeanServerIfNecessary;
    static final Pattern typeQueryPattern = Pattern.compile(",(.*?)=");
    private final Set<JmxAttributeProcessor> jmxAttributeProcessors = new HashSet<JmxAttributeProcessor>();
    private final String defaultApplication;

    public JmxService() {
        super(JmxService.class.getSimpleName());
        IAgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        Config jmxConfig = new Config((Map)config.getProperty("jmx"));
        this.enabled = jmxConfig.getProperty("enabled", true);
        this.createMBeanServerIfNecessary = jmxConfig.getProperty("create_mbean_server", true);
        InstrumentationProxy instrumentation = ServiceFactory.getAgent().getInstrumentation();
        this.jmxConfigFactory = JmxConfigFactory.createJmxConfigFactory(instrumentation);
        this.defaultApplication = config.getApplicationName();
    }

    public List<JmxConfigFactory.JmxConfig> getConfigurations() {
        return Collections.unmodifiableList(this.configs);
    }

    public void addJmxAttributeProcessor(JmxAttributeProcessor attributeProcessor) {
        this.jmxAttributeProcessors.add(attributeProcessor);
    }

    @Override
    protected void doStart() {
        if (this.enabled) {
            for (Extension extension : ServiceFactory.getExtensionService().getExtensions().values()) {
                Object jmx;
                if (!extension.isEnabled() || (jmx = extension.getConfiguration().getProperty("jmx")) == null || !(jmx instanceof List)) continue;
                this.addConfiguration((List)jmx);
            }
            if (this.configs.size() > 0) {
                ServiceFactory.getHarvestService().addHarvestListener(this);
            }
            this.addJmxAttributeProcessor(JmxAttributeProcessorWrapper.createInstance(J2EE_STATS_ATTRIBUTE_PROCESSOR_CLASS_NAME));
            this.addJmxAttributeProcessor(JmxAttributeProcessorWrapper.createInstance(WEBSPHERE_STATS_ATTRIBUTE_PROCESSOR_CLASS_NAME));
        }
    }

    public void createMBeanServerIfNecessary() {
        if (System.getProperty("com.sun.management.jmxremote") == null && MBeanServerFactory.findMBeanServer(null).isEmpty() && this.createMBeanServerIfNecessary) {
            try {
                MBeanServerFactory.createMBeanServer();
                this.getLogger().log(Level.FINE, "Created a default MBeanServer");
            }
            catch (Exception e) {
                Agent.LOG.severe("The JMX Service was unable to create a default mbean server");
            }
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    private void addConfiguration(List<Map> config) {
        if (config != null) {
            for (Map jmxConfig : config) {
                try {
                    this.addJmxConfig(this.jmxConfigFactory.getJmxConfig(jmxConfig));
                }
                catch (MalformedObjectNameException e) {}
            }
        }
    }

    void addJmxConfig(JmxConfigFactory.JmxConfig jmxConfig) {
        String msg = MessageFormat.format("Adding JMX config: {0}", jmxConfig);
        Agent.LOG.finer(msg);
        this.configs.add(jmxConfig);
    }

    @Override
    protected void doStop() {
        this.configs.clear();
        this.jmxAttributeProcessors.clear();
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        if (!this.defaultApplication.equals(appName)) {
            return;
        }
        Agent.LOG.log(Level.FINER, "Harvesting JMX metrics");
        try {
            this.process(statsEngine);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unexpected error querying MBeans in JMX service: ", e.toString());
            this.getLogger().finer(msg);
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    private void process(StatsEngine statsEngine, List<MBeanServer> srvrList, JmxConfigFactory.JmxConfig config, Set<String> metricNames) {
        ObjectName name = config.getObjectName();
        if (name == null) {
            return;
        }
        for (MBeanServer server : srvrList) {
            Set<ObjectInstance> queryMBeans = server.queryMBeans(name, null);
            this.getLogger().finer(MessageFormat.format("JMX Service : MBeans query {0}, matches {1}", name, queryMBeans.size()));
            block3: for (ObjectInstance instance : queryMBeans) {
                ObjectName actualName = instance.getObjectName();
                String rootMetricName = JmxService.getRootMetricName(config, actualName);
                try {
                    String[] attributes;
                    Map<String, JmxMetric> metrics = config.getMetrics();
                    for (String attr : attributes = metrics.keySet().toArray(new String[metrics.size()])) {
                        String[] compNames = attr.split("\\.");
                        JmxMetric metric = metrics.get(attr);
                        if (metric == null) {
                            Agent.LOG.severe(MessageFormat.format("An error occurred fetching the JMX metric \"{0}\"", rootMetricName + attr));
                            continue block3;
                        }
                        String metricName = rootMetricName + metric.getAttribute();
                        if (metricNames.contains(metricName)) {
                            this.getLogger().fine(MessageFormat.format("The agent was configured to record the JMX metric \"{0}\" more than once", metricName));
                            continue;
                        }
                        Object attrObj = server.getAttribute(instance.getObjectName(), compNames[0]);
                        if (attrObj instanceof Attribute) {
                            this.recordJmxValue(statsEngine, instance, (Attribute)attrObj, metric, metricName);
                        } else if (attrObj instanceof CompositeDataSupport) {
                            if (compNames.length == 2) {
                                this.recordJmxValue(statsEngine, instance, new Attribute(attr, ((CompositeDataSupport)attrObj).get(compNames[1])), metric, metricName);
                            } else {
                                this.getLogger().fine(MessageFormat.format("Found CompositeDataSupport object for {0}, but no object attribute specified, correct syntax is object.attribute", metricName));
                            }
                        } else {
                            this.recordJmxValue(statsEngine, instance, new Attribute(attr, attrObj), metric, metricName);
                        }
                        metricNames.add(metricName);
                    }
                }
                catch (Exception e) {
                    this.getLogger().fine(MessageFormat.format("An error occurred fetching JMX metric for {0}", name));
                    this.getLogger().log(Level.FINER, "JMX error", e);
                }
            }
        }
    }

    private void recordJmxValue(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, JmxMetric metric, String metricName) {
        if (this.recordCustomJmxValue(statsEngine, instance, attribute, metricName)) {
            return;
        }
        Object value = attribute.getValue();
        Number num = null;
        if (value instanceof Number) {
            num = (Number)value;
        } else if (value instanceof Boolean) {
            num = (Boolean)value != false ? 1 : 0;
        } else if (value != null) {
            try {
                num = Float.valueOf(Float.parseFloat(value.toString()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (num != null) {
            this.getLogger().finer(MessageFormat.format("Recording JMX metric {0} : {1}", metricName, value));
            metric.recordStats(statsEngine, metricName, num.floatValue());
        } else if (value == null) {
            this.getLogger().fine(MessageFormat.format("MBean {0} attribute {1} value is null", instance.getObjectName(), metric.getAttribute()));
        } else {
            this.getLogger().fine(MessageFormat.format("MBean {0} attribute {1} is not a number ({2}/{3})", instance.getObjectName(), metric.getAttribute(), value, value.getClass().getName()));
        }
    }

    private boolean recordCustomJmxValue(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String metricName) {
        for (JmxAttributeProcessor processor : this.jmxAttributeProcessors) {
            if (!processor.process(statsEngine, instance, attribute, metricName)) continue;
            return true;
        }
        return false;
    }

    static String getRootMetricName(JmxConfigFactory.JmxConfig config, ObjectName actualName) {
        Hashtable<String, String> keyProperties = actualName.getKeyPropertyList();
        String type = keyProperties.remove("type");
        StringBuilder rootPath = new StringBuilder("JMX").append('/');
        if (actualName.getDomain() != null) {
            rootPath.append(actualName.getDomain()).append('/');
        }
        rootPath.append(type);
        if (keyProperties.size() > 1) {
            String str = config.getObjectNameString();
            Matcher matcher = typeQueryPattern.matcher(str);
            while (matcher.find()) {
                String group = matcher.group(1);
                String val = keyProperties.remove(group);
                if (val == null) continue;
                rootPath.append('/');
                rootPath.append(JmxService.formatSegment(val));
            }
        }
        if (keyProperties.size() == 1) {
            rootPath.append('/');
            rootPath.append(JmxService.formatSegment(keyProperties.entrySet().iterator().next().getValue()));
        }
        rootPath.append('/');
        return rootPath.toString();
    }

    private void process(StatsEngine statsEngine) {
        HashSet<String> metricNames = new HashSet<String>();
        ArrayList<MBeanServer> srvrList = MBeanServerFactory.findMBeanServer(null);
        this.getLogger().fine(MessageFormat.format("JMX Service : querying MBeans ({0})", srvrList.size()));
        for (JmxConfigFactory.JmxConfig config : this.configs) {
            this.process(statsEngine, srvrList, config, metricNames);
        }
    }

    private static String formatSegment(String metricSegment) {
        if (metricSegment.startsWith("/")) {
            return metricSegment.substring(1);
        }
        return metricSegment;
    }
}

