/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.jmx.JmxMetric;
import com.newrelic.agent.jmx.JmxService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxConfigFactory {
    public JmxConfig getJmxConfig(Map jmxConfig) throws MalformedObjectNameException {
        return new JmxConfig(jmxConfig);
    }

    protected JmxConfig getJmxConfig5(Map jmxConfig) throws MalformedObjectNameException {
        return new JmxConfig5(jmxConfig);
    }

    static JmxConfigFactory createJmxConfigFactory(InstrumentationProxy instrumentation) {
        return JmxConfigFactory.createJmxConfigFactory(instrumentation == null ? 6 : instrumentation.getMinorJVMVersion());
    }

    static JmxConfigFactory createJmxConfigFactory(int minorJVMVersion) {
        if (minorJVMVersion == 5) {
            return new JmxConfigFactory5();
        }
        return new JmxConfigFactory();
    }

    public List<JmxMetric> getJmxMetrics(Map<?, ?> metricMap) {
        String type = this.findType(metricMap);
        List<String> attributes = this.findAttributes(metricMap);
        ArrayList<JmxMetric> metrics = new ArrayList<JmxMetric>();
        for (String attribute : attributes) {
            JmxMetric metric = JmxMetric.create(attribute, type);
            metrics.add(metric);
        }
        return metrics;
    }

    private String findType(Map<?, ?> metricMap) {
        String type = (String)metricMap.get("type");
        if (type == null) {
            return "monotonically_increasing";
        }
        if (type.equals("monotonically_increasing") || type.equals("simple")) {
            return type;
        }
        String msg = MessageFormat.format("Unknown JMX metric type: {0}.  Using default type: {1}", type, "monotonically_increasing");
        Agent.LOG.warning(msg);
        return "monotonically_increasing";
    }

    private List<String> findAttributes(Map<?, ?> metricMap) {
        ArrayList<String> result = new ArrayList<String>();
        String attributes = (String)metricMap.get("attributes");
        if (attributes != null) {
            for (String attribute : attributes.split(",")) {
                result.add(attribute.trim());
            }
        } else {
            String attribute = (String)metricMap.get("attribute");
            if (attribute != null) {
                result.add(attribute.trim());
            }
        }
        return result;
    }

    private class JmxConfig5
    extends JmxConfig {
        public JmxConfig5(Map jmxConfig) throws MalformedObjectNameException {
            super(jmxConfig);
        }

        protected String getSafeObjectName(String objectNameString) {
            Matcher matcher = JmxService.typeQueryPattern.matcher(objectNameString);
            if (matcher.find()) {
                String group = matcher.group(1);
                int start = matcher.start();
                objectNameString = objectNameString.substring(0, start) + ",*";
            }
            return objectNameString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JmxConfig {
        private final Map<String, JmxMetric> metrics;
        private ObjectName objectName;
        private final String objectNameString;

        public JmxConfig(Map jmxConfig) throws MalformedObjectNameException {
            this.objectNameString = (String)jmxConfig.get("object_name");
            Boolean enabled = (Boolean)jmxConfig.get("enabled");
            if (enabled == null || enabled.booleanValue()) {
                String safeName = this.getSafeObjectName(this.objectNameString);
                try {
                    this.objectName = new ObjectName(safeName);
                }
                catch (MalformedObjectNameException e) {
                    if (!this.objectNameString.equals(safeName)) {
                        safeName = safeName + '(' + this.objectNameString + ')';
                    }
                    Agent.LOG.severe(MessageFormat.format("Skipping bad Jmx object name : {0}.  {1}", safeName, e.toString()));
                    Agent.LOG.log(Level.FINER, "Jmx config error", e);
                    throw e;
                }
                this.metrics = this.initializeMetrics(jmxConfig);
            } else {
                this.metrics = Collections.emptyMap();
            }
        }

        private Map<String, JmxMetric> initializeMetrics(Map jmxConfig) {
            HashMap<String, JmxMetric> metricsMap = new HashMap<String, JmxMetric>();
            List metrics = (List)jmxConfig.get("metrics");
            for (Map metric : metrics) {
                for (JmxMetric jmxMetric : JmxConfigFactory.this.getJmxMetrics(metric)) {
                    metricsMap.put(jmxMetric.getAttribute(), jmxMetric);
                }
            }
            return metricsMap;
        }

        protected String getSafeObjectName(String objectNameString) {
            return objectNameString;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }

        public String getObjectNameString() {
            return this.objectNameString;
        }

        public Map<String, JmxMetric> getMetrics() {
            return this.metrics;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("object_name: ").append(this.objectNameString);
            sb.append(" attributes: [");
            Iterator<JmxMetric> it = this.metrics.values().iterator();
            while (it.hasNext()) {
                JmxMetric metric = it.next();
                sb.append(metric.getAttribute()).append(" type: ").append(metric.getType());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static class JmxConfigFactory5
    extends JmxConfigFactory {
        private JmxConfigFactory5() {
        }

        public JmxConfig getJmxConfig(Map jmxConfig) throws MalformedObjectNameException {
            return this.getJmxConfig5(jmxConfig);
        }
    }
}

