/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import com.newrelic.agent.jmx.AbstractStatsAttributeProcessor;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.ObjectInstance;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;

public class J2EEStatsAttributeProcessor
extends AbstractStatsAttributeProcessor {
    public boolean process(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String metricName) {
        Object value = attribute.getValue();
        if (value instanceof Stats) {
            Stats jmxStats = (Stats)value;
            for (Statistic statistic : jmxStats.getStatistics()) {
                this.processStatistic(statsEngine, instance, attribute, metricName, statistic);
            }
            Agent.LOG.finer(MessageFormat.format("Processed J2EE statistic: {0}", metricName));
            return true;
        }
        Agent.LOG.finer(MessageFormat.format("Attribute value is not a javax.management.j2ee.statistics.Stats: {0}", value.getClass().getName()));
        return false;
    }

    private void processStatistic(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String metricName, Statistic statistic) {
        String fullMetricName = metricName + '/' + statistic.getName();
        Agent.LOG.finer(MessageFormat.format("Processing J2EE statistic: {0} class: {1}", fullMetricName, statistic.getClass().getName()));
        if (statistic instanceof CountStatistic) {
            CountStatistic stat = (CountStatistic)statistic;
            statsEngine.getStats(fullMetricName).setCallCount((int)stat.getCount());
        } else if (statistic instanceof RangeStatistic) {
            RangeStatistic stat = (RangeStatistic)statistic;
            statsEngine.getStats(fullMetricName).recordDataPoint(stat.getCurrent());
        } else if (statistic instanceof BoundaryStatistic) {
            BoundaryStatistic stat = (BoundaryStatistic)statistic;
            statsEngine.getStats(fullMetricName).recordDataPoint(stat.getLowerBound());
            statsEngine.getStats(fullMetricName).recordDataPoint(stat.getUpperBound());
        } else if (statistic instanceof TimeStatistic) {
            TimeStatistic stat = (TimeStatistic)statistic;
            TimeUnit unit = J2EEStatsAttributeProcessor.getTimeUnit(stat.getUnit());
            statsEngine.getResponseTimeStats(fullMetricName).recordResponseTime((int)stat.getCount(), stat.getTotalTime(), stat.getMinTime(), stat.getMaxTime(), unit);
        }
    }
}

