/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.yaml;

import com.newrelic.agent.instrumentation.yaml.MetricNameFormatFactory;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.agent.instrumentation.yaml.SimpleMetricNameFormatFactory;
import com.newrelic.agent.tracers.metricname.OtherTransSimpleMetricNameFormat;
import java.util.Collections;
import java.util.Map;

public class TracerFactoryConfiguration {
    private final boolean dispatcher;
    private final MetricNameFormatFactory metricNameFormatFactory;
    private final Map attributes;

    public TracerFactoryConfiguration(String defaultMetricPrefix, Map attributes) {
        this.attributes = Collections.unmodifiableMap(attributes);
        Object dispatcherProp = attributes.get("dispatcher");
        this.dispatcher = dispatcherProp != null && Boolean.parseBoolean(dispatcherProp.toString());
        Object format = attributes.get("metric_name_format");
        if (format instanceof String) {
            this.metricNameFormatFactory = new SimpleMetricNameFormatFactory(new OtherTransSimpleMetricNameFormat(format.toString()));
        } else if (null == format) {
            this.metricNameFormatFactory = new PointCutFactory.ClassMethodNameFormatDescriptor(defaultMetricPrefix, this.dispatcher);
        } else if (format instanceof MetricNameFormatFactory) {
            this.metricNameFormatFactory = (MetricNameFormatFactory)format;
        } else {
            throw new RuntimeException("Unsupported metric_name_format value");
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public MetricNameFormatFactory getMetricNameFormatFactory() {
        return this.metricNameFormatFactory;
    }

    public boolean isDispatcher() {
        return this.dispatcher;
    }
}

