/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.solr;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.solr.AbstractSolrPointCut;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.jar.Manifest;

@PointCut
public class SolrCorePointCut
extends AbstractSolrPointCut {
    private static final String POINT_CUT_NAME = SolrCorePointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String SOLR_CORE_CLASS = "org/apache/solr/core/SolrCore";
    private static final String INIT_INDEX_METHOD_NAME = "initIndex";
    private static final String INIT_INDEX_METHOD_DESC = "()V";
    private static final String INIT_INDEX_METHOD_4_0_DESC = "(Z)V";

    public SolrCorePointCut(ClassTransformer classTransformer) {
        super(SolrCorePointCut.createPointCutConfig(), SolrCorePointCut.createClassMatcher(), SolrCorePointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, null, true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(SOLR_CORE_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(INIT_INDEX_METHOD_NAME, INIT_INDEX_METHOD_DESC, INIT_INDEX_METHOD_4_0_DESC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object core, Object[] args) {
        String version = null;
        try {
            InputStream iStream = core.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
            try {
                Manifest manifest = new Manifest(iStream);
                version = manifest.getMainAttributes().getValue("Specification-Version");
            }
            finally {
                iStream.close();
            }
        }
        catch (Exception e) {
            Agent.LOG.fine("Unable to determine the Solr version : " + e.toString());
        }
        try {
            version = version == null ? this.getVersion(core) : version;
        }
        catch (Exception e) {
            version = "1.0";
        }
        Agent.LOG.fine("Setting environment variable: Solr Version: " + version);
        ServiceFactory.getEnvironmentService().getEnvironment().addVariable("Solr Version", version);
        this.checkJmxConfig(core);
        return null;
    }

    private void checkJmxConfig(Object core) {
        try {
            Object config = core.getClass().getClassLoader().loadClass("org.apache.solr.core.SolrCore").getMethod("getSolrConfig", new Class[0]).invoke(core, new Object[0]);
            Object jmxConfig = config.getClass().getDeclaredField("jmxConfig").get(config);
            boolean enabled = jmxConfig.getClass().getDeclaredField("enabled").getBoolean(jmxConfig);
            if (!enabled) {
                Agent.LOG.severe("Solr JMX metrics are not enabled.  The agent will not report Solr JMX data.  Add a <jmx/> node to solrconfig.xml to enable them (refer to the Solr documentation).");
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to determine if Solr JMX metrics are enabled : {0}", e.toString());
            Agent.LOG.severe(msg);
        }
    }

    private Object getVersion(Object core) throws Exception {
        return core.getClass().getMethod("getVersion", new Class[0]).invoke(core, new Object[0]);
    }
}

