/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.DefaultPointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.AndClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.NotMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.servlet.ServletTracerFactory;

@PointCut
public class ServletPointCut
extends DefaultPointCut {
    public static final String SERVLET_SERVICE_METHOD_NAME = "service";
    public static final String SERVLET_SERVICE_METHOD_DESC = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;)V";
    private static final String SERVLET_INTERFACE = "javax/servlet/Servlet";

    public ServletPointCut(ClassTransformer ct) {
        super(ServletPointCut.createPointCutConfig(), ServletPointCut.createTracerFactory(), ServletPointCut.createClassMatcher(), ServletPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(ServletPointCut.class);
    }

    protected static ClassMatcher createClassMatcher() {
        return new AndClassMatcher(new InterfaceMatcher(SERVLET_INTERFACE), new NotMatcher(new ChildClassMatcher("javax/servlet/http/HttpServlet")));
    }

    private static MethodMatcher createMethodMatcher() {
        return ServletPointCut.createExactMethodMatcher(SERVLET_SERVICE_METHOD_NAME, SERVLET_SERVICE_METHOD_DESC);
    }

    private static TracerFactory createTracerFactory() {
        return new ServletTracerFactory();
    }
}

