/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.play;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.text.MessageFormat;

@PointCut
public class PlayControllerPointCut
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = PlayControllerPointCut.class.getName();
    private static final String CONTROLLER_CLASS = "play/mvc/Controller";
    private static final String AWAIT_METHOD_NAME = "await";
    private static final String AWAIT_METHOD_DESC_1 = "(I)V";
    private static final String AWAIT_METHOD_DESC_2 = "(Ljava/util/concurrent/Future;)Ljava/lang/Object;";
    private static final String AWAIT_METHOD_DESC_3 = "(ILplay/libs/F$Action0;)V";
    private static final String AWAIT_METHOD_DESC_4 = "(Ljava/util/concurrent/Future;Lplay/libs/F$Action;)V";
    private static final String RENDER_TEMPLATE_METHOD_NAME = "renderTemplate";
    private static final String RENDER_TEMPLATE_METHOD_DESC = "(Ljava/lang/String;Ljava/util/Map;)V";
    private static final String TEMPLATE_METRIC_NAME = "Controller.renderTemplate/{0}";
    private static final String AWAIT_METRIC_NAME = "Controller.await";
    private static final String SUSPEND_EXECPTION_CLASS = "play.Invoker$Suspend";

    public PlayControllerPointCut(ClassTransformer classTransformer) {
        super(PlayControllerPointCut.createPointCutConfig(), PlayControllerPointCut.createClassMatcher(), PlayControllerPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "play_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(CONTROLLER_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(RENDER_TEMPLATE_METHOD_NAME, RENDER_TEMPLATE_METHOD_DESC), new ExactMethodMatcher(AWAIT_METHOD_NAME, AWAIT_METHOD_DESC_1, AWAIT_METHOD_DESC_2, AWAIT_METHOD_DESC_3, AWAIT_METHOD_DESC_4));
    }

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
        if (AWAIT_METHOD_NAME == sig.getMethodName()) {
            return this.getAwaitTracer(tx, sig, object, args);
        }
        return this.getRenderTracer(tx, sig, object, args);
    }

    private Tracer getAwaitTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
        SimpleMetricNameFormat format = new SimpleMetricNameFormat(AWAIT_METRIC_NAME);
        if (sig.getMethodDesc() == AWAIT_METHOD_DESC_3 || sig.getMethodDesc() == AWAIT_METHOD_DESC_4) {
            return new PlayControllerTracer(tx, sig, object, format);
        }
        return new DefaultTracer(tx, sig, object, format);
    }

    private Tracer getRenderTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
        String templateName = (String)args[0];
        String metricName = MessageFormat.format(TEMPLATE_METRIC_NAME, templateName);
        SimpleMetricNameFormat format = new SimpleMetricNameFormat(metricName);
        return new DefaultTracer(tx, sig, object, format);
    }

    private static class PlayControllerTracer
    extends DefaultTracer {
        public PlayControllerTracer(Transaction tx, ClassMethodSignature sig, Object object, MetricNameFormat format) {
            super(tx, sig, object, format);
        }

        protected void doFinish(Throwable throwable) {
            if (throwable.getClass().getName() == PlayControllerPointCut.SUSPEND_EXECPTION_CLASS) {
                this.getTransaction().getTransactionState().suspendRootTracer();
            }
        }
    }
}

