/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentUtils;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.Tracer;
import java.net.HttpURLConnection;
import java.net.URL;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class HttpURLConnectionPointCut2
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = HttpURLConnectionPointCut2.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final boolean ONLY_MATCH_CHILDREN = false;
    private static final String GET_RESPONSE_CODE_METHOD_NAME = "getResponseCode";
    private static final String GET_RESPONSE_CODE_METHOD_DESC = "()I";
    private static final String HTTP_URL_CONNECTION_CLASS_NAME = "java/net/HttpURLConnection";

    public HttpURLConnectionPointCut2(ClassTransformer classTransformer) {
        super(HttpURLConnectionPointCut2.createPointCutConfig(), HttpURLConnectionPointCut2.createClassMatcher(), HttpURLConnectionPointCut2.createMethodMatcher());
        classTransformer.getClassNameFilter().addIncludeClass(HTTP_URL_CONNECTION_CLASS_NAME);
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ChildClassMatcher(HTTP_URL_CONNECTION_CLASS_NAME, false);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(GET_RESPONSE_CODE_METHOD_NAME, GET_RESPONSE_CODE_METHOD_DESC);
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
        try {
            ServiceFactory.getAgent().getInstrumentation().retransformUninstrumentedClasses(HTTP_URL_CONNECTION_CLASS_NAME.replaceAll("/", "."));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object urlConnection, Object[] args) {
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        URL url = connection.getURL();
        String uri = InstrumentUtils.getURI(url);
        String host = url.getHost();
        String methodName = sig.getMethodName();
        return new HttpURLConnectionTracer2(this, transaction, sig, urlConnection, host, "HttpURLConnection", uri, new String[]{methodName});
    }

    private static final class HttpURLConnectionTracer2
    extends ExternalComponentTracer
    implements IOTracer {
        private HttpURLConnectionTracer2(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String uri, String[] operations) {
            super(transaction, sig, object, host, library, uri, operations);
        }

        public TransactionSegment getTransactionSegment(ITransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
            if (lastSibling != null && lastSibling.getMetricName().equals(this.getTransactionSegmentName())) {
                lastSibling.merge(this);
                return lastSibling;
            }
            return super.getTransactionSegment(ttConfig, sqlObfuscator, startTime, lastSibling);
        }
    }
}

