/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentUtils;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.net.HttpURLConnectionTracer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.net.HttpURLConnection;
import java.net.URL;

@PointCut
public class HttpURLConnectionPointCut
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = HttpURLConnectionPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = false;
    private static final boolean ONLY_MATCH_CHILDREN = false;
    private static final String CONNECT_METHOD_NAME = "connect";
    private static final String CONNECT_METHOD_DESC = "()V";
    private static final String HTTP_URL_CONNECTION_CLASS_NAME = "java/net/HttpURLConnection";
    private static final String TO_INCLUDE_CHILD = "sun/net/www/protocol/http/HttpURLConnection";

    public HttpURLConnectionPointCut(ClassTransformer classTransformer) {
        super(HttpURLConnectionPointCut.createPointCutConfig(), HttpURLConnectionPointCut.createClassMatcher(), HttpURLConnectionPointCut.createMethodMatcher());
        classTransformer.getClassNameFilter().addIncludeClass(HTTP_URL_CONNECTION_CLASS_NAME);
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, false);
    }

    private static ClassMatcher createClassMatcher() {
        return new ChildClassMatcher(HTTP_URL_CONNECTION_CLASS_NAME, false, new String[]{TO_INCLUDE_CHILD});
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(CONNECT_METHOD_NAME, CONNECT_METHOD_DESC);
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
        try {
            ServiceFactory.getAgent().getInstrumentation().retransformUninstrumentedClasses(HTTP_URL_CONNECTION_CLASS_NAME.replaceAll("/", "."));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object urlConnection, Object[] args) {
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        String crossProcessId = transaction.getCrossProcessConfig().getEncodedCrossProcessId();
        if (crossProcessId != null) {
            connection.setRequestProperty("X-NewRelic-ID", crossProcessId);
            String json = transaction.getCrossProcessTransactionState().getTransactionHeaderValue();
            if (json != null) {
                connection.setRequestProperty("X-NewRelic-Transaction", json);
            }
        }
        URL url = connection.getURL();
        String uri = InstrumentUtils.getURI(url);
        String host = url.getHost();
        String methodName = sig.getMethodName();
        return new HttpURLConnectionTracer(transaction, sig, urlConnection, host, "HttpURLConnection", uri, methodName);
    }
}

