/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.hibernate;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.pointcuts.hibernate.HibernateStatisticsService;
import com.newrelic.agent.stats.MonotonicallyIncreasingStatsEngine;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.hibernate.SessionFactory;
import org.hibernate.jmx.StatisticsService;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;

public class StatisticsSampler {
    private static final String HIBERNATE_STATISTICS = "HibernateStatistics";
    private static final String ENTITIES = "HibernateStatistics/Entity";
    private static final String SECOND_LEVEL_CACHE = "HibernateStatistics/SecondLevelCache";
    private final StatisticsService statisticsService;
    private final MonotonicallyIncreasingStatsEngine monoStatsEngine = new MonotonicallyIncreasingStatsEngine();

    public StatisticsSampler(SessionFactory sessionFactory) {
        this.statisticsService = new StatisticsService();
        this.statisticsService.setSessionFactory(sessionFactory);
        if (!this.statisticsService.isStatisticsEnabled()) {
            this.statisticsService.setStatisticsEnabled(true);
            Agent.LOG.log(Level.INFO, "Enabled Hibernate JMX metrics");
        }
        HibernateStatisticsService statsService = HibernateStatisticsService.getHibernateStatisticsService(this.getClass().getClassLoader());
        statsService.addStatisticsSampler(this);
    }

    public void recordStats(StatsEngine statsEngine) {
        String[] regionNames;
        String[] entityNames;
        this.recordMonoStats(statsEngine, "HibernateStatistics/entityLoads", this.statisticsService.getEntityLoadCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/entityFetches", this.statisticsService.getEntityFetchCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/entityInserts", this.statisticsService.getEntityInsertCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/entityUpdates", this.statisticsService.getEntityUpdateCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/entityDeletes", this.statisticsService.getEntityDeleteCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/queryCacheHits", this.statisticsService.getQueryCacheHitCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/queryCacheMisses", this.statisticsService.getQueryCacheMissCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/queryCachePuts", this.statisticsService.getQueryCachePutCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/queryExecutions", this.statisticsService.getQueryExecutionCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/sessionOpens", this.statisticsService.getSessionOpenCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/sessionCloses", this.statisticsService.getSessionCloseCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/transactions", this.statisticsService.getTransactionCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/closeStatements", this.statisticsService.getCloseStatementCount());
        this.recordMonoStats(statsEngine, "HibernateStatistics/flushes", this.statisticsService.getFlushCount());
        for (String name : entityNames = this.statisticsService.getEntityNames()) {
            EntityStatistics stats = this.statisticsService.getEntityStatistics(name);
            String rootName = "HibernateStatistics/Entity/" + name + '/';
            Class<?> clazz = stats.getClass();
            try {
                Method m = clazz.getDeclaredMethod("getLoadCount", new Class[0]);
                long res = (Long)m.invoke((Object)stats, new Object[0]);
                this.recordMonoStats(statsEngine, rootName + "loads", res);
                m = clazz.getDeclaredMethod("getFetchCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.recordMonoStats(statsEngine, rootName + "fetches", res);
                m = clazz.getDeclaredMethod("getInsertCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.recordMonoStats(statsEngine, rootName + "inserts", res);
                m = clazz.getDeclaredMethod("getUpdateCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.recordMonoStats(statsEngine, rootName + "updates", res);
                m = clazz.getDeclaredMethod("getDeleteCount", new Class[0]);
                res = (Long)m.invoke((Object)stats, new Object[0]);
                this.recordMonoStats(statsEngine, rootName + "deletes", res);
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Error in Hibernate StatisticsSampler: {0}", e);
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, e);
                    continue;
                }
                Agent.LOG.fine(msg);
            }
        }
        for (String name : regionNames = this.statisticsService.getSecondLevelCacheRegionNames()) {
            SecondLevelCacheStatistics cacheStatistics = this.statisticsService.getSecondLevelCacheStatistics(name);
            String rootName = "HibernateStatistics/SecondLevelCache/" + name + '/';
            this.recordMonoStats(statsEngine, rootName + "elementsInMemory", cacheStatistics.getElementCountInMemory());
            this.recordMonoStats(statsEngine, rootName + "elementsOnDisk", cacheStatistics.getElementCountOnDisk());
            this.recordMonoStats(statsEngine, rootName + "hits", cacheStatistics.getHitCount());
            this.recordMonoStats(statsEngine, rootName + "misses", cacheStatistics.getMissCount());
            this.recordMonoStats(statsEngine, rootName + "puts", cacheStatistics.getPutCount());
        }
    }

    private void recordMonoStats(StatsEngine statsEngine, String name, float value) {
        this.monoStatsEngine.recordMonoStats(statsEngine, name, value);
    }
}

