/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.hibernate;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.instrumentation.pointcuts.hibernate.StatisticsSampler;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;

public class HibernateStatisticsService
extends AbstractService
implements HarvestListener {
    public static final String SERVICE_NAME = HibernateStatisticsService.class.getSimpleName();
    private final Collection<StatisticsSampler> samplers = new ArrayList<StatisticsSampler>();
    private final String appName = ServiceFactory.getConfigService().getAgentConfig().getApplicationName();

    public HibernateStatisticsService() {
        super(SERVICE_NAME);
    }

    static synchronized HibernateStatisticsService getHibernateStatisticsService(ClassLoader classLoader) {
        HibernateStatisticsService service = (HibernateStatisticsService)ServiceFactory.getService(SERVICE_NAME);
        if (service == null) {
            service = new HibernateStatisticsService();
            ServiceFactory.getHarvestService().addHarvestListener(service);
            ServiceFactory.addService(service);
        }
        return service;
    }

    public synchronized void addStatisticsSampler(StatisticsSampler sampler) {
        this.samplers.add(sampler);
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doStart() {
    }

    protected synchronized void doStop() {
        this.samplers.clear();
    }

    public synchronized void beforeHarvest(String appName, StatsEngine statsEngine) {
        if (!this.appName.equals(appName)) {
            return;
        }
        try {
            for (StatisticsSampler sampler : this.samplers) {
                sampler.recordStats(statsEngine);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Hibernate statistics gathering error: {0}", e);
            Agent.LOG.fine(msg);
        }
    }

    public void afterHarvest(String appName) {
    }
}

