/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.frameworks.spring.HandlerMethodInvokerPointCut;
import com.newrelic.agent.instrumentation.pointcuts.frameworks.spring.ModelAndView;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.transaction.HigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@PointCut
public class SpringPointCut
extends TracerFactoryPointCut {
    public static final String SPRING_CONTROLLER = "SpringController";
    public static final String SPRING_VIEW = "SpringView";
    private static final String REDIRECT_VIEW_SYNTAX = "/redirect:";
    private static final String FORWARD_VIEW_SYNTAX = "/forward:";
    private static final Pattern HTTP_PATTERN = Pattern.compile("(.*)https?://.*");
    private final boolean normalizeTransactions = HandlerMethodInvokerPointCut.useViewNameToNormalize(ServiceFactory.getConfigService().getAgentConfig());

    public SpringPointCut(ClassTransformer ct) {
        super(SpringPointCut.class, (ClassMatcher)new InterfaceMatcher("org/springframework/web/servlet/HandlerAdapter"), (MethodMatcher)new ExactMethodMatcher("handle", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Ljava/lang/Object;)Lorg/springframework/web/servlet/ModelAndView;"));
    }

    static String getModelAndViewViewName(Object modelAndView) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String viewName = modelAndView instanceof ModelAndView ? ((ModelAndView)modelAndView).getViewName() : (String)modelAndView.getClass().getMethod("getViewName", new Class[0]).invoke(modelAndView, new Object[0]);
        return SpringPointCut.cleanModelAndViewName(viewName);
    }

    static String cleanModelAndViewName(String viewName) {
        if (viewName == null || viewName.length() == 0) {
            return viewName;
        }
        if (viewName.charAt(0) != '/') {
            viewName = '/' + viewName;
        }
        if (viewName.startsWith(REDIRECT_VIEW_SYNTAX)) {
            return "/redirect:*";
        }
        if (viewName.startsWith(FORWARD_VIEW_SYNTAX)) {
            return null;
        }
        viewName = ServiceFactory.getNormalizationService().getUrlBeforeParameters(viewName);
        Matcher paramDelimiterMatcher = HTTP_PATTERN.matcher(viewName);
        if (paramDelimiterMatcher.matches()) {
            viewName = paramDelimiterMatcher.group(1) + '*';
        }
        return viewName;
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, final Object controller, Object[] args) {
        final Object handler = args[2];
        return new DefaultTracer(transaction, sig, controller){

            protected void doFinish(int opcode, Object modelView) {
                if (modelView != null && SpringPointCut.this.normalizeTransactions) {
                    this.setTransactionName(this.transaction, modelView);
                }
                String metricName = handler != null ? "SpringController/" + handler.getClass().getName() : ClassMethodMetricNameFormat.getMetricName(this.getClassMethodSignature(), controller, "SpringController/Java");
                this.setMetricNameFormat(new SimpleMetricNameFormat(metricName));
                super.doFinish(opcode, modelView);
            }

            private void setTransactionName(Transaction transaction, Object modelView) {
                HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
                if (policy.canSetTransactionName(transaction, TransactionNamePriority.FRAMEWORK)) {
                    String modelAndViewName = this.doGetModelAndViewName(modelView);
                    if (modelAndViewName == null) {
                        return;
                    }
                    if (Agent.LOG.isLoggable(Level.FINER)) {
                        String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Spring ModelView", modelAndViewName);
                        Agent.LOG.finer(msg);
                    }
                    policy.setTransactionName(transaction, modelAndViewName, SpringPointCut.SPRING_VIEW, TransactionNamePriority.FRAMEWORK);
                }
            }

            private String doGetModelAndViewName(Object modelAndView) {
                try {
                    return SpringPointCut.getModelAndViewViewName(modelAndView);
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINE, "Unable to parse Spring ModelView", e);
                    return null;
                }
            }
        };
    }

    public boolean isEnabled() {
        return ServiceFactory.getConfigService().getAgentConfig().getProperty("enable_spring_tracing", true);
    }
}

