/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.transaction.HigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import java.text.MessageFormat;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodInvokerPointCut
extends TracerFactoryPointCut {
    private static final String TRANSACTION_NAMING_CONFIG_PARAMETER_NAME = "transaction_naming_scheme";
    private static final String SPRING_FRAMEWORK_CONFIG_PARAMETER_NAME = "spring_framework";
    private static final String CONTROLLER_METHOD_NAMING = "controller_method";
    private static final String VIEW_NAMING = "view";
    private static final String DEFAULT_NAMING_METHOD = "controller_method";
    protected static final String TO_REMOVE = "$$EnhancerByCGLIB";
    private final boolean useFullPackageName;
    private final boolean normalizeTransactions;
    private final boolean normalizationDisabled;

    public MethodInvokerPointCut(ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        super(new PointCutConfiguration("spring_handler_method_invoker"), classMatcher, methodMatcher);
        AgentConfig config = ServiceFactory.getConfigService().getAgentConfig();
        this.useFullPackageName = MethodInvokerPointCut.getSpringConfiguration(config).getProperty("use_full_package_name", false);
        this.normalizeTransactions = "controller_method".equals(MethodInvokerPointCut.getSpringConfiguration(config).getProperty(TRANSACTION_NAMING_CONFIG_PARAMETER_NAME, "controller_method"));
        this.normalizationDisabled = !this.normalizeTransactions && !MethodInvokerPointCut.useViewNameToNormalize(config);
    }

    private static Config getSpringConfiguration(AgentConfig config) {
        return config.getInstrumentationConfig().getConfig(SPRING_FRAMEWORK_CONFIG_PARAMETER_NAME);
    }

    static boolean useViewNameToNormalize(AgentConfig config) {
        return VIEW_NAMING.equals(MethodInvokerPointCut.getSpringConfiguration(config).getProperty(TRANSACTION_NAMING_CONFIG_PARAMETER_NAME, "controller_method"));
    }

    protected boolean isNormalizeTransactions() {
        return this.normalizeTransactions;
    }

    protected boolean isNormalizationDisabled() {
        return this.normalizationDisabled;
    }

    protected boolean isUseFullPackageName() {
        return this.useFullPackageName;
    }

    protected void setTransactionName(Transaction transaction, String methodName, Class<?> pController) {
        HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
        if (policy.canSetTransactionName(transaction, TransactionNamePriority.FRAMEWORK)) {
            String controller = this.getControllerName(methodName, pController);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Spring controller", controller);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(transaction, controller, "SpringController", TransactionNamePriority.FRAMEWORK);
        }
    }

    private String getControllerName(String methodName, Class<?> controller) {
        String controllerName = this.isUseFullPackageName() ? controller.getName() : controller.getSimpleName();
        int indexOf = controllerName.indexOf(TO_REMOVE);
        if (indexOf > 0) {
            controllerName = controllerName.substring(0, indexOf);
        }
        return '/' + controllerName + '/' + methodName;
    }
}

