/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectiveDataSource
implements DataSource {
    private static final String DATASOURCE_CLASS_NAME = DataSource.class.getName();
    private final Object dataSource;
    private final Class<?> dataSourceClass;

    public ReflectiveDataSource(Object dataSource) throws ClassNotFoundException {
        this.dataSource = dataSource;
        dataSource.getClass();
        this.dataSourceClass = Class.forName(DATASOURCE_CLASS_NAME);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return (Connection)this.invoke("getConnection", new Object[0]);
    }

    private <T> T invoke(String methodName, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        try {
            return (T)this.dataSourceClass.getMethod(methodName, argTypes).invoke(this.dataSource, args);
        }
        catch (Throwable e) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, "Unable to invoke DataSource method " + methodName, e);
            }
            return null;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return (Connection)this.invoke("getConnection", username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }
}

