/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.pointcuts.database.AbstractPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import com.newrelic.agent.instrumentation.pointcuts.database.PreparedStatementExplainPlanExecutor;
import com.newrelic.agent.instrumentation.pointcuts.database.PreparedStatementExtension;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.instrumentation.pointcuts.database.StatementData;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.org.json.simple.JSONAware;

class PreparedStatementTracer
extends SqlStatementTracer {
    private Object[] sqlParameters;
    private final PreparedStatementExtension preparedStatement;

    public PreparedStatementTracer(Transaction transaction, ClassMethodSignature sig, PreparedStatementExtension preparedStatement, StatementData statementData) {
        super(transaction, sig, (Object)preparedStatement, statementData);
        this.preparedStatement = preparedStatement;
    }

    protected void doFinish(int opcode, Object returnValue) {
        if ("raw" == this.transaction.getTransactionTracerConfig().getRecordSql() || (double)this.getDuration() > this.transaction.getTransactionTracerConfig().getExplainThresholdInNanos()) {
            Object[] parameters = this.preparedStatement._nr_getSqlParameters();
            Object[] objectArray = this.sqlParameters = parameters == null ? null : new Object[parameters.length];
            if (parameters != null) {
                System.arraycopy(parameters, 0, this.sqlParameters, 0, parameters.length);
            }
        }
        super.doFinish(opcode, returnValue);
    }

    protected Object getSqlObject() {
        String sql = this.preparedStatement._nr_getStatementData().getSql();
        if (this.sqlParameters != null && this.sqlParameters.length > 0) {
            return new PreparedStatementSql(sql, this.sqlParameters);
        }
        return sql;
    }

    protected ExplainPlanExecutor createExplainPlanExecutor(String sql) {
        return new PreparedStatementExplainPlanExecutor(this, sql, this.sqlParameters);
    }

    private static class PreparedStatementSql
    implements JSONAware {
        private final String sql;
        private final Object[] sqlParameters;

        public PreparedStatementSql(String sql, Object[] sqlParameters) {
            this.sql = sql;
            this.sqlParameters = sqlParameters;
        }

        public String toJSONString() {
            try {
                return AbstractPreparedStatementPointCut.parameterizeSql(this.sql, this.sqlParameters);
            }
            catch (Exception e) {
                return this.sql;
            }
        }

        public String toString() {
            return this.toJSONString();
        }
    }
}

