/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.instrumentation.pointcuts.database.DefaultExplainPlanExecutor;
import com.newrelic.agent.tracers.ISqlStatementTracer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class PreparedStatementExplainPlanExecutor
extends DefaultExplainPlanExecutor {
    private final Object[] sqlParameters;

    public PreparedStatementExplainPlanExecutor(ISqlStatementTracer tracer, String originalSqlStatement, Object[] sqlParameters) {
        super(tracer, originalSqlStatement);
        this.sqlParameters = sqlParameters;
    }

    protected Statement createStatement(Connection connection, String sql) throws SQLException {
        return connection.prepareStatement(sql);
    }

    protected ResultSet executeStatement(Statement statement, String sql) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)statement;
        this.setSqlParameters(preparedStatement);
        return preparedStatement.executeQuery();
    }

    private void setSqlParameters(PreparedStatement preparedStatement) throws SQLException {
        if (null == this.sqlParameters) {
            return;
        }
        int length = this.sqlParameters.length;
        try {
            length = Math.min(length, preparedStatement.getMetaData().getColumnCount());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            for (int i = 0; i < length; ++i) {
                preparedStatement.setObject(i + 1, this.sqlParameters[i]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

