/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.websphere;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.MethodMapper;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.websphere.DelegatingWebCommerceHttpResponse;
import com.newrelic.agent.instrumentation.pointcuts.container.websphere.DelegatingWebSphereHttpRequest;
import com.newrelic.agent.instrumentation.pointcuts.container.websphere.DelegatingWebSphereHttpResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.util.Enumeration;

@PointCut
public class WebSphereDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    private static final String REQUEST_CLASS = "com/ibm/ws/webcontainer/channel/WCCRequestImpl";
    private static final String RESPONSE_CLASS = "com/ibm/ws/webcontainer/channel/WCCResponseImpl";
    private static final String WEB_COMMERCE_RESPONSE_CLASS = "com/ibm/commerce/messaging/viewcommands/WCMSResponse";
    private static final String WEB_CONTAINER_CLASS = "com/ibm/ws/webcontainer/WebContainer";
    private static final String HANDLE_REQUEST_METHOD_NAME = "handleRequest";
    private static final String HANDLE_REQUEST_DESC = "(Lcom/ibm/websphere/servlet/request/IRequest;Lcom/ibm/websphere/servlet/response/IResponse;)V";

    public WebSphereDispatcherPointCut(ClassTransformer classTransformer) {
        super(WebSphereDispatcherPointCut.class, WebSphereDispatcherPointCut.createClassMatcher(), WebSphereDispatcherPointCut.createMethodMatcher());
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(WEB_CONTAINER_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(HANDLE_REQUEST_METHOD_NAME, HANDLE_REQUEST_DESC);
    }

    protected HttpRequest getRequest(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        Object request = args[0];
        WebSphereHttpRequest webSphereHttpRequest = null;
        if (request instanceof WebSphereHttpRequest) {
            webSphereHttpRequest = (WebSphereHttpRequest)request;
        }
        HttpRequestMessage httpRequestMessage = null;
        if (request instanceof WCCRequest) {
            WCCRequest wccRequest = (WCCRequest)request;
            httpRequestMessage = (HttpRequestMessage)wccRequest._nr_getHttpRequestMessage();
        }
        return DelegatingWebSphereHttpRequest.create(webSphereHttpRequest, httpRequestMessage);
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        Object response = args[1];
        if (response instanceof WebCommerceHttpResponse) {
            return DelegatingWebCommerceHttpResponse.create((WebCommerceHttpResponse)response);
        }
        WebSphereHttpResponse webSphereHttpResponse = null;
        if (response instanceof WebSphereHttpResponse) {
            webSphereHttpResponse = (WebSphereHttpResponse)response;
        }
        HttpResponseMessage httpResponseMessage = null;
        if (response instanceof WCCResponse) {
            WCCResponse wccResponse = (WCCResponse)response;
            httpResponseMessage = (HttpResponseMessage)wccResponse._nr_getHttpResponseMessage();
        }
        return DelegatingWebSphereHttpResponse.create(webSphereHttpResponse, httpResponseMessage);
    }

    @InterfaceMixin(originalClassName={"com/ibm/commerce/messaging/viewcommands/WCMSResponse"})
    public static interface WebCommerceHttpResponse {
        public int getStatusCode();

        public void addHeader(String var1, String var2);

        public String getReason();

        public String getContentType();
    }

    @InterfaceMixin(originalClassName={"com/ibm/wsspi/http/channel/HttpResponseMessage"})
    public static interface HttpResponseMessage {
        public int getStatusCodeAsInt();

        public String getReasonPhrase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @InterfaceMixin(originalClassName={"com/ibm/wsspi/http/channel/HttpRequestMessage"})
    public static interface HttpRequestMessage {
        public Enumeration<?> getParameterNames();

        public String[] getParameterValues(String var1);
    }

    @InterfaceMixin(originalClassName={"com/ibm/websphere/servlet/response/IResponse"})
    public static interface WebSphereHttpResponse {
        public void setHeader(String var1, String var2);
    }

    @InterfaceMapper(originalInterfaceName="com/ibm/ws/webcontainer/channel/WCCResponseImpl")
    public static interface WCCResponse {
        @MethodMapper(originalMethodName="getHttpResponse", originalDescriptor="()Lcom/ibm/wsspi/http/channel/HttpResponseMessage;", invokeInterface=false)
        public Object _nr_getHttpResponseMessage();
    }

    @InterfaceMapper(originalInterfaceName="com/ibm/ws/webcontainer/channel/WCCRequestImpl")
    public static interface WCCRequest {
        @MethodMapper(originalMethodName="getHttpRequest", originalDescriptor="()Lcom/ibm/wsspi/http/channel/HttpRequestMessage;", invokeInterface=false)
        public Object _nr_getHttpRequestMessage();
    }

    @InterfaceMixin(originalClassName={"com/ibm/websphere/servlet/request/IRequest"})
    public static interface WebSphereHttpRequest {
        public String getRequestURI();

        public String getHeader(String var1);

        public String getRemoteUser();

        public byte[] getCookieValue(String var1);
    }
}

