/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.websphere;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.pointcuts.container.websphere.WebSphereDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingWebSphereHttpRequest
implements HttpRequest {
    private final WebSphereDispatcherPointCut.WebSphereHttpRequest delegate;
    private final WebSphereDispatcherPointCut.HttpRequestMessage messageDelegate;

    private DelegatingWebSphereHttpRequest(WebSphereDispatcherPointCut.WebSphereHttpRequest delegate, WebSphereDispatcherPointCut.HttpRequestMessage messageDelegate) {
        this.delegate = delegate;
        this.messageDelegate = messageDelegate;
    }

    @Override
    public Enumeration<?> getParameterNames() {
        return this.messageDelegate == null ? null : this.messageDelegate.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.messageDelegate == null ? new String[]{} : this.messageDelegate.getParameterValues(name);
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public String getRequestURI() {
        return this.delegate.getRequestURI();
    }

    @Override
    public String getHeader(String name) {
        return this.delegate.getHeader(name);
    }

    @Override
    public String getRemoteUser() {
        return this.delegate.getRemoteUser();
    }

    @Override
    public boolean isAsyncStarted() {
        return false;
    }

    @Override
    public boolean isAsyncSupported() {
        return false;
    }

    @Override
    public AsyncContextNr getAsyncContextNr() {
        return null;
    }

    @Override
    public String getCookieValue(String name) {
        byte[] bytes = this.delegate.getCookieValue(name);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String msg = MessageFormat.format("WebSphereHttpRequest error getting cookie value for \"{0}\": {1}", name, e);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.WARNING, msg, e);
            } else {
                Agent.LOG.warning(msg);
            }
            return null;
        }
    }

    static HttpRequest create(WebSphereDispatcherPointCut.WebSphereHttpRequest delegate, WebSphereDispatcherPointCut.HttpRequestMessage messageDelegate) {
        return new DelegatingWebSphereHttpRequest(delegate, messageDelegate);
    }
}

