/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.weblogic;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.DelegatingServletHttpRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.HttpServletResponse;
import com.newrelic.agent.tracers.servlet.HttpServletResponse24;
import com.newrelic.agent.tracers.servlet.HttpServletResponseExtension;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class WebLogicDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    private static final String POINT_CUT_NAME = WebLogicDispatcherPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String SERVLET_CONTEXT_CLASS = "weblogic/servlet/internal/WebAppServletContext";
    private static final String EXECUTE_METHOD_NAME = "execute";
    private static final String EXECUTE_METHOD_DESC = "(Lweblogic/servlet/internal/ServletRequestImpl;Lweblogic/servlet/internal/ServletResponseImpl;)V";

    public WebLogicDispatcherPointCut(ClassTransformer classTransformer) {
        super(WebLogicDispatcherPointCut.createPointCutConfig(), WebLogicDispatcherPointCut.createClassMatcher(), WebLogicDispatcherPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, null, true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(SERVLET_CONTEXT_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(EXECUTE_METHOD_NAME, EXECUTE_METHOD_DESC);
    }

    protected HttpRequest getRequest(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
        HttpServletRequest servletRequest = (HttpServletRequest)args[0];
        return DelegatingServletHttpRequest.create(servletRequest);
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        Object response = args[1];
        final HttpServletResponse httpServletResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : null;
        final HttpServletResponse24 httpServletResponse24 = response instanceof HttpServletResponse24 ? (HttpServletResponse24)response : null;
        final HttpServletResponseExtension responseExtension = response instanceof HttpServletResponseExtension ? (HttpServletResponseExtension)response : null;
        return new HttpResponse(){

            public int _nr_getResponseStatus() throws Exception {
                if (responseExtension == null) {
                    return 0;
                }
                try {
                    return responseExtension.getStatus();
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Exception calling getStatus(): {0}", t);
                    if (Agent.LOG.isLoggable(Level.FINEST)) {
                        Agent.LOG.log(Level.FINEST, msg, t);
                    } else {
                        Agent.LOG.finer(msg);
                    }
                    return 0;
                }
            }

            public String _nr_getResponseStatusMessage() throws Exception {
                return null;
            }

            public String _nr_getContentType() throws Exception {
                if (httpServletResponse24 == null) {
                    return null;
                }
                try {
                    return httpServletResponse24.getContentType();
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Exception calling getContentType(): {0}", t);
                    if (Agent.LOG.isLoggable(Level.FINEST)) {
                        Agent.LOG.log(Level.FINEST, msg, t);
                    } else {
                        Agent.LOG.finer(msg);
                    }
                    return null;
                }
            }

            public void _nr_setHeader(String name, String value) {
                if (httpServletResponse == null) {
                    return;
                }
                try {
                    httpServletResponse.setHeader(name, value);
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Exception calling setHeader(): {0}", t);
                    if (Agent.LOG.isLoggable(Level.FINEST)) {
                        Agent.LOG.log(Level.FINEST, msg, t);
                    }
                    Agent.LOG.finer(msg);
                }
            }
        };
    }
}

