/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.weblogic;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Environment;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Field;
import java.util.logging.Level;

@PointCut
public class HttpServerPointCut
extends TracerFactoryPointCut {
    public HttpServerPointCut(ClassTransformer classTransformer) {
        super(HttpServerPointCut.class, (ClassMatcher)new ExactClassMatcher("weblogic/server/channels/DynamicListenThread"), HttpServerPointCut.createExactMethodMatcher("start", "(ZZZ)Z"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, final Object server, Object[] args) {
        return new MethodExitTracer(sig, transaction){

            protected void doFinish(int opcode, Object returnValue) {
                Environment env = ServiceFactory.getEnvironmentService().getEnvironment();
                if (env.getDispatcher() == null) {
                    env.setDispatcher("WebLogic");
                }
                try {
                    Field field = server.getClass().getDeclaredField("port");
                    field.setAccessible(true);
                    Integer port = (Integer)field.get(server);
                    ServiceFactory.getRPMService().setApplicationServerPort(port);
                }
                catch (Throwable t) {
                    Agent.LOG.log(Level.FINE, "Unable to get WebLogic HttpServer port", t);
                }
            }
        };
    }
}

