/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.container.tomcat.TomcatDispatcherPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class ResponseSendHeadersPointCut
extends PointCut
implements EntryInvocationHandler {
    private static final String POINT_CUT_NAME = TomcatDispatcherPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String COYOTE_RESPONSE_CLASS = "org/apache/coyote/Response";
    private static final String GRIZZLY_RESPONSE_CLASS = "com/sun/grizzly/tcp/Response";
    private static final String SEND_HEADERS_METHOD_NAME = "sendHeaders";
    private static final String SEND_HEADERS_METHOD_DESC = "()V";

    public ResponseSendHeadersPointCut(ClassTransformer classTransformer) {
        super(ResponseSendHeadersPointCut.createPointCutConfig(), ResponseSendHeadersPointCut.createClassMatcher(), ResponseSendHeadersPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "tomcat_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return ExactClassMatcher.or(COYOTE_RESPONSE_CLASS, GRIZZLY_RESPONSE_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(SEND_HEADERS_METHOD_NAME, SEND_HEADERS_METHOD_DESC);
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        Transaction tx = Transaction.getTransaction();
        if (tx == null) {
            return;
        }
        tx.beforeSendResponseHeaders();
    }
}

