/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.pointcuts.container.tomcat.TomcatServletRequest;
import com.newrelic.agent.tracers.servlet.AbstractDelegatingServletHttpRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.HttpServletRequestExtension;
import com.newrelic.agent.tracers.servlet.ServletRequest30;
import com.newrelic.agent.tracers.servlet.ServletRequest30Extension;
import java.text.MessageFormat;
import java.util.logging.Level;

public class DelegatingTomcatServletRequest
extends AbstractDelegatingServletHttpRequest {
    private final TomcatServletRequest delegate;

    private DelegatingTomcatServletRequest(TomcatServletRequest delegate) {
        this.delegate = delegate;
    }

    protected HttpServletRequest getDelegate() {
        return this.delegate;
    }

    protected HttpServletRequestExtension getExtensionDelegate() {
        return this.delegate;
    }

    protected ServletRequest30 getDelegate30() {
        return null;
    }

    protected ServletRequest30Extension getExtensionDelegate30() {
        return null;
    }

    public String getCookieValue(String name) {
        try {
            return this.getCookieValue2(name);
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception in {0}.getCookieValue(String): {1}", this.delegate.getClass().getName(), t);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, t);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    private String getCookieValue2(String name) {
        int count = this.delegate._nr_getCookieCount();
        for (int i = 0; i < count; ++i) {
            String cookieName = this.delegate._nr_getCookieName(i);
            if (!name.equals(cookieName)) continue;
            String cookieValue = this.delegate._nr_getCookieValue(i);
            return cookieValue;
        }
        return null;
    }

    public static HttpRequest create(TomcatServletRequest delegate) {
        return new DelegatingTomcatServletRequest(delegate);
    }
}

