/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.logging.Level;

@PointCut
public class ConnectorPointCut
extends TracerFactoryPointCut {
    private volatile boolean portSet = false;

    public ConnectorPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("catalina_connector", "tomcat_instrumentation", true), (ClassMatcher)new ExactClassMatcher("org/apache/catalina/connector/Connector"), ConnectorPointCut.createExactMethodMatcher("start", "()V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object connector, Object[] args) {
        if (!this.portSet) {
            try {
                Integer port = (Integer)connector.getClass().getMethod("getPort", new Class[0]).invoke(connector, new Object[0]);
                ServiceFactory.getRPMService().setApplicationServerPort(port);
                this.portSet = true;
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.FINER, "Unable to get connector port", t);
            }
        }
        return null;
    }
}

