/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.resin;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.pointcuts.container.resin.DelegatingResinRequest;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.tracers.servlet.AbstractHttpResponse;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.AsyncDispatcherTracerFactory;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.DelegatingServletHttpRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.ServletRequest30;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ResinServletTracerFactory
extends AsyncDispatcherTracerFactory {
    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object servlet, Object[] args) {
        DispatcherTracer rootTracer = tx.getRootTracer();
        if (rootTracer != null) {
            return null;
        }
        HttpRequest request = this.getRequest(args);
        AsyncContextNr asyncContext = this.getAsyncContext(request);
        this.resumeSavedTransaction(asyncContext);
        ResinResponse httpResponse = new ResinResponse(args[1]);
        return this.getDispatcherTracer(tx, sig, servlet, request, httpResponse);
    }

    private HttpRequest getRequest(Object[] args) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)args[0];
        if (httpServletRequest instanceof ServletRequest30) {
            return DelegatingServletHttpRequest.create(httpServletRequest);
        }
        return DelegatingResinRequest.create(httpServletRequest);
    }

    public Tracer getDispatcherTracer(Transaction tx, ClassMethodSignature sig, Object servlet, HttpRequest request, HttpResponse response) {
        try {
            MetricNameFormat format = this.getMetricNameFormat(sig, servlet);
            return new BasicRequestDispatcherTracer(tx, sig, servlet, request, response, format);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to create request dispatcher tracer: {0}", e);
            Agent.LOG.log(Level.SEVERE, msg, e);
            return null;
        }
    }

    private MetricNameFormat getMetricNameFormat(ClassMethodSignature sig, Object servlet) {
        return new SimpleMetricNameFormat("RequestDispatcher", ClassMethodMetricNameFormat.getMetricName(sig, servlet, "RequestDispatcher"));
    }

    private static class ResinResponse
    extends AbstractHttpResponse {
        public ResinResponse(Object response) {
            super(response);
        }

        public int _nr_getResponseStatus() throws Exception {
            Method method;
            try {
                method = this.response.getClass().getMethod("getStatusCode", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                method = this.response.getClass().getMethod("getStatus", new Class[0]);
            }
            method.setAccessible(true);
            return (Integer)method.invoke(this.response, new Object[0]);
        }

        public String _nr_getResponseStatusMessage() throws Exception {
            return null;
        }

        public String _nr_getContentType() throws Exception {
            return null;
        }
    }
}

