/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.oc4j;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.logging.Level;

@PointCut
public class HandleExceptionPointCut
extends TracerFactoryPointCut {
    public HandleExceptionPointCut(ClassTransformer classTransformer) {
        super(HandleExceptionPointCut.class, (ClassMatcher)new ExactClassMatcher("com/evermind/server/http/HttpRequestHandler"), HandleExceptionPointCut.createExactMethodMatcher("handleHttpException", "(Lcom/evermind/server/http/EvermindHttpServletRequest;Lcom/evermind/server/http/EvermindHttpServletResponse;Lcom/evermind/server/http/HttpException;)V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        Exception exception = (Exception)args[2];
        transaction.setThrowable(exception);
        try {
            int status = (Integer)exception.getClass().getMethod("getStatusCode", new Class[0]).invoke((Object)exception, new Object[0]);
            transaction.setStatus(status);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "Unable to get the http status code from an HttpException", e);
        }
        return null;
    }
}

