/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.oc4j;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.FieldAccessor;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.oc4j.DelegatingEvermindServletHttpResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.DelegatingServletHttpRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.HttpServletResponse24;

@PointCut
public class EvermindDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    static final String HTTP_REQUEST_HANDLER_CLASS_NAME = "com/evermind/server/http/HttpRequestHandler";
    private static final String DO_PROCESS_REQUEST_METHOD_NAME = "doProcessRequest";
    private static final String DO_PROCESS_REQUEST_METHOD_DESC = "(Lcom/evermind/server/ApplicationServerThread;Lcom/evermind/server/http/EvermindHttpServletRequest;Lcom/evermind/server/http/EvermindHttpServletResponse;Ljava/io/InputStream;Ljava/io/OutputStream;Z)Z";

    public EvermindDispatcherPointCut(ClassTransformer classTransformer) {
        super(EvermindDispatcherPointCut.createPointCutConfig(), EvermindDispatcherPointCut.createClassMatcher(), EvermindDispatcherPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(EvermindDispatcherPointCut.class);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(HTTP_REQUEST_HANDLER_CLASS_NAME);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(DO_PROCESS_REQUEST_METHOD_NAME, DO_PROCESS_REQUEST_METHOD_DESC);
    }

    protected HttpRequest getRequest(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        Object request = args[1];
        if (request instanceof EvermindHttpServletRequest) {
            return DelegatingServletHttpRequest.create((EvermindHttpServletRequest)request);
        }
        return null;
    }

    protected HttpResponse getResponse(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) throws Exception {
        Object response = args[2];
        if (response instanceof EvermindHttpServletResponse) {
            return DelegatingEvermindServletHttpResponse.create((EvermindHttpServletResponse)response);
        }
        return null;
    }

    @InterfaceMixin(originalClassName={"com/evermind/server/http/EvermindHttpServletResponse"})
    public static interface EvermindHttpServletResponse
    extends HttpServletResponse24 {
        @FieldAccessor(fieldName="status", existingField=true)
        public int _nr_getStatus();

        @FieldAccessor(fieldName="statusMessage", existingField=true)
        public String _nr_getStatusMessage();
    }

    @InterfaceMixin(originalClassName={"com/evermind/server/http/EvermindHttpServletRequest"})
    public static interface EvermindHttpServletRequest
    extends HttpServletRequest {
    }
}

