/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.SystemSamplerPointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.Jetty5Sampler;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.Jetty6Sampler;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.Jetty7Sampler;
import com.newrelic.agent.samplers.MetricSampler;

@PointCut
public class JettyServerPointCut
extends SystemSamplerPointCut {
    static final String JETTY5_SERVER_CLASS_NAME = "org/mortbay/http/HttpServer";
    static final String JETTY6_SERVER_CLASS_NAME = "org/mortbay/jetty/Server";
    static final String JETTY7_SERVER_CLASS_NAME = "org/eclipse/jetty/server/Server";
    static final String JETTY4_START_METHOD_NAME = "start";
    static final String JETTY5_START_METHOD_NAME = "doStart";
    static final String JETTY_START_METHOD_DESC = "()V";

    public JettyServerPointCut(ClassTransformer classTransformer) {
        super(JettyServerPointCut.createPointCutConfig(), JettyServerPointCut.createClassMatcher(), JettyServerPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(JettyServerPointCut.class.getName(), "jetty_server", true);
    }

    private static ClassMatcher createClassMatcher() {
        return ExactClassMatcher.or(JETTY5_SERVER_CLASS_NAME, JETTY6_SERVER_CLASS_NAME, JETTY7_SERVER_CLASS_NAME);
    }

    private static MethodMatcher createMethodMatcher() {
        return OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(JETTY4_START_METHOD_NAME, JETTY_START_METHOD_DESC), new ExactMethodMatcher(JETTY5_START_METHOD_NAME, JETTY_START_METHOD_DESC));
    }

    protected MetricSampler getSampler(Object server, String serverClassName) throws Exception {
        if (JETTY7_SERVER_CLASS_NAME.equals(serverClassName)) {
            return new Jetty7Sampler(server);
        }
        if (JETTY5_SERVER_CLASS_NAME.equals(serverClassName)) {
            return new Jetty5Sampler(server);
        }
        return new Jetty6Sampler(server);
    }

    protected String getServerName() {
        return "Jetty";
    }
}

