/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.AJettyPointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.Jetty5DelegatingServletHttpRequest;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.Jetty5DelegatingServletHttpResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.RequestDispatcherTracerFactory;
import java.util.logging.Level;

@PointCut
public class JettyServer5DispatcherPointCut
extends AJettyPointCut {
    private static final String POINT_CUT_NAME = "jetty_5_dispatcher";
    private static final String SERVICE_METHOD_NAME = "service";
    private static final String SERVICE_METHOD_DESC = "(Lorg/mortbay/http/HttpRequest;Lorg/mortbay/http/HttpResponse;)Lorg/mortbay/http/HttpContext;";

    public JettyServer5DispatcherPointCut(ClassTransformer classTransformer) {
        super(POINT_CUT_NAME, JettyServer5DispatcherPointCut.createTracerFactory(), JettyServer5DispatcherPointCut.createClassMatcher(), JettyServer5DispatcherPointCut.createMethodMatcher());
    }

    private static TracerFactory createTracerFactory() {
        return new DispatcherTracerFactory();
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("org/mortbay/http/HttpServer");
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(SERVICE_METHOD_NAME, SERVICE_METHOD_DESC);
    }

    @InterfaceMixin(originalClassName={"org/mortbay/http/HttpRequest"})
    public static interface Jetty5HttpRequest
    extends HttpServletRequest {
        public Object getWrapper();
    }

    @InterfaceMixin(originalClassName={"org/mortbay/http/HttpResponse"})
    public static interface Jetty5HttpResponse {
        public int getStatus();

        public String getReason();

        public Object getWrapper();
    }

    private static class DispatcherTracerFactory
    extends RequestDispatcherTracerFactory {
        private DispatcherTracerFactory() {
        }

        protected Tracer getTracerImpl(Transaction tx, ClassMethodSignature sig, Object httpServer, Object[] args) {
            try {
                HttpRequest httpRequest = this.createHttpRequest(args[0]);
                HttpResponse httpResponse = this.createHttpResponse(args[1]);
                return new BasicRequestDispatcherTracer(tx, sig, httpServer, httpRequest, httpResponse);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, "Unable to create Jetty dispatcher tracer", e);
                return null;
            }
        }

        private HttpRequest createHttpRequest(Object request) {
            if (request instanceof Jetty5HttpRequest) {
                Jetty5HttpRequest httpServletRequest = (Jetty5HttpRequest)request;
                return Jetty5DelegatingServletHttpRequest.create(httpServletRequest);
            }
            return null;
        }

        private HttpResponse createHttpResponse(Object response) {
            if (response instanceof Jetty5HttpResponse) {
                Jetty5HttpResponse jetty5HttpResponse = (Jetty5HttpResponse)response;
                return Jetty5DelegatingServletHttpResponse.create(jetty5HttpResponse);
            }
            return null;
        }
    }
}

