/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettyDelegatingServletHttpRequest;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettyDispatcherTracerFactory;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettyResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.AsyncDispatcherTracerFactory;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;

public class Jetty7DispatcherTracerFactory
extends AsyncDispatcherTracerFactory {
    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object server, Object[] args) {
        DispatcherTracer rootTracer = tx.getRootTracer();
        if (rootTracer != null) {
            return null;
        }
        Object connection = args[0];
        HttpRequest request = this.getRequest(connection);
        AsyncContextNr asyncContext = this.getAsyncContext(request);
        this.resumeSavedTransaction(asyncContext);
        HttpResponse response = this.getResponse(connection);
        return new BasicRequestDispatcherTracer(tx, sig, server, request, response);
    }

    private HttpResponse getResponse(Object connection) {
        Object response = null;
        if (connection instanceof JettyDispatcherTracerFactory.IHttpConnection) {
            response = ((JettyDispatcherTracerFactory.IHttpConnection)connection)._nr_getResponse();
        }
        return JettyResponse.getJettyResponse(response);
    }

    private HttpRequest getRequest(Object connection) {
        HttpServletRequest httpServletRequest = null;
        if (connection instanceof JettyDispatcherTracerFactory.IHttpConnection) {
            httpServletRequest = (HttpServletRequest)((JettyDispatcherTracerFactory.IHttpConnection)connection)._nr_getRequest();
        }
        return JettyDelegatingServletHttpRequest.create(httpServletRequest);
    }
}

