/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.methodmatchers;

import com.newrelic.agent.extension.beans.Method;
import com.newrelic.agent.extension.util.MethodMapper;
import com.newrelic.agent.extension.util.MethodParameters;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcherUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrExactParamMethodMatcher
implements MethodMatcher {
    private final Map<String, List<String>> nameDescriptorCombos;

    public OrExactParamMethodMatcher(Map<String, List<String>> pNameDescriptions) {
        this.nameDescriptorCombos = pNameDescriptions == null ? new HashMap<String, List<String>>() : pNameDescriptions;
    }

    public static OrExactParamMethodMatcher createOrExactParamMethodMatcher(List<Method> methods, String associatedClassName, Map<String, MethodMapper> previous) {
        if (methods == null || methods.isEmpty()) {
            throw new RuntimeException("Methods are required to create a method matcher.");
        }
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        for (Method current : methods) {
            if (current == null) {
                throw new RuntimeException("A method must be specified for a point cut in the extension.");
            }
            String name = current.getName();
            if (name == null) {
                throw new RuntimeException("A method name must be specified for a point cut in the extension.");
            }
            if ((name = name.trim()).length() == 0) {
                throw new RuntimeException("A method must be specified for a point cut in the extension.");
            }
            MethodParameters mParams = current.getParameters();
            if (mParams == null) {
                mParams = new MethodParameters(new ArrayList<String>());
            }
            if (mParams.isWasError()) {
                throw new RuntimeException(mParams.getErrorMessage());
            }
            if (mParams.getDescriptor() == null) {
                throw new RuntimeException("Descriptor not being calculated correctly.");
            }
            String mDescriptor = mParams.getDescriptor().trim();
            if (MethodMatcherUtility.isDuplicateMethod(associatedClassName, name, mDescriptor, previous)) continue;
            ArrayList<String> descriptors = (ArrayList<String>)data.get(name);
            if (descriptors == null) {
                descriptors = new ArrayList<String>();
                data.put(name, descriptors);
            }
            if (descriptors.contains(mDescriptor)) continue;
            descriptors.add(mDescriptor);
        }
        if (data.isEmpty()) {
            throw new RuntimeException("All methods for " + associatedClassName + " have already been added.");
        }
        return new OrExactParamMethodMatcher(data);
    }

    @Override
    public boolean matches(String pName, String pDesc) {
        List<String> paramDescriptors;
        if (pDesc != null && (paramDescriptors = this.nameDescriptorCombos.get(pName)) != null) {
            for (String descriptor : paramDescriptors) {
                if (!pDesc.startsWith(descriptor)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OrExactParamMethodMatcher(");
        for (Map.Entry<String, List<String>> values : this.nameDescriptorCombos.entrySet()) {
            sb.append(" ");
            sb.append(values.getKey());
            sb.append("(");
            if (values.getValue() != null) {
                for (String desc : values.getValue()) {
                    sb.append(desc);
                    sb.append(" ");
                }
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }
}

