/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.util.Strings;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.Type;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceMatcher
extends ClassMatcher {
    private final String internalInterfaceName;
    private final String interfaceName;

    public InterfaceMatcher(String interfaceName) {
        interfaceName = Strings.fixInternalClassName(interfaceName);
        this.interfaceName = Type.getObjectType(interfaceName).getClassName();
        this.internalInterfaceName = interfaceName;
        if (interfaceName.indexOf(47) < 0) {
            throw new RuntimeException("Invalid class name format");
        }
    }

    @Override
    public boolean isMatch(ClassLoader loader, String currentClassName, ClassReader cr) {
        if (this.isNotMatch(loader, currentClassName, cr)) {
            return false;
        }
        String[] interfaces = cr.getInterfaces();
        return Arrays.asList(interfaces).contains(this.internalInterfaceName);
    }

    @Override
    public boolean isMatch(Class clazz) {
        try {
            Class<?> interfaceClass;
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if ((interfaceClass = classLoader.loadClass(this.interfaceName)).isAssignableFrom(clazz)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isNotMatch(ClassLoader loader, String className, ClassReader cr) {
        return loader == null || className.equals(this.internalInterfaceName);
    }

    public String toString() {
        return this.interfaceName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalInterfaceName == null ? 0 : this.internalInterfaceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceMatcher other = (InterfaceMatcher)obj;
        return !(this.internalInterfaceName == null ? other.internalInterfaceName != null : !this.internalInterfaceName.equals(other.internalInterfaceName));
    }

    @Override
    public Collection<String> getClassNames() {
        return Arrays.asList(this.internalInterfaceName);
    }
}

