/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PrimitiveConverter {
    private static final Map<Type, Type> primitiveToObjectType = Collections.unmodifiableMap(new HashMap<Type, Type>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Type.BOOLEAN_TYPE, Type.getType(Boolean.class));
            this.put(Type.BYTE_TYPE, Type.getType(Byte.class));
            this.put(Type.CHAR_TYPE, Type.getType(Character.class));
            this.put(Type.DOUBLE_TYPE, Type.getType(Double.class));
            this.put(Type.FLOAT_TYPE, Type.getType(Float.class));
            this.put(Type.INT_TYPE, Type.getType(Integer.class));
            this.put(Type.LONG_TYPE, Type.getType(Long.class));
            this.put(Type.SHORT_TYPE, Type.getType(Short.class));
        }
    });

    private PrimitiveConverter() {
    }

    public static void boxPrimitive(GeneratorAdapter adapter, Type primitiveType) {
        Type objectType = primitiveToObjectType.get(primitiveType);
        if (null == objectType) {
            throw new IllegalArgumentException(primitiveType.getDescriptor() + " is not a primitive type");
        }
        String methodDesc = "(" + primitiveType.getDescriptor() + ")" + objectType.getDescriptor();
        adapter.invokeStatic(objectType, new Method("valueOf", methodDesc));
    }

    public static Object valueOf(final GeneratorAdapter adapter, final boolean val) {
        return new Runnable(){

            public void run() {
                adapter.push(val);
                PrimitiveConverter.boxPrimitive(adapter, Type.BOOLEAN_TYPE);
            }
        };
    }

    public static Object valueOf(final GeneratorAdapter adapter, final int value) {
        return new Runnable(){

            public void run() {
                adapter.visitIntInsn(17, value);
                PrimitiveConverter.boxPrimitive(adapter, Type.INT_TYPE);
            }
        };
    }
}

