/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import com.newrelic.org.objectweb.asm.Label;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import java.io.ByteArrayInputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRelicClassLoaderClassTransformer
implements StartableClassFileTransformer {
    private final ClassMatcher classMatcher;
    private final IAgentLogger logger;
    private final int classReaderFlags;
    private final String[] appClassLoaders;
    private static final Set<String> METHOD_DESCRIPTIONS_TO_MATCH = new HashSet<String>(Arrays.asList("(Ljava/lang/String;)Ljava/lang/Class;", "(Ljava/lang/String;Z)Ljava/lang/Class;"));

    public NewRelicClassLoaderClassTransformer(int classReaderFlags) {
        this.classReaderFlags = classReaderFlags;
        this.appClassLoaders = ServiceFactory.getConfigService().getAgentConfig().getClassTransformerConfig().getAppClassLoaders();
        this.classMatcher = new ClassMatcher(){

            @Override
            public boolean isNotMatch(ClassLoader loader, String className, ClassReader cr) {
                return NewRelicClassLoaderClassTransformer.this.isCoreLibrary(className);
            }

            @Override
            public boolean isMatch(Class clazz) {
                return false;
            }

            @Override
            public boolean isMatch(ClassLoader loader, String className, ClassReader cr) {
                if (className.equals("oracle/classloader/PolicyClassLoader")) {
                    return false;
                }
                if (!NewRelicClassLoaderClassTransformer.this.isCoreLibrary(className) && (className.contains("ClassLoader") || className.contains("Classloader"))) {
                    return true;
                }
                for (String clazz : NewRelicClassLoaderClassTransformer.this.appClassLoaders) {
                    if (!clazz.equals(className)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Collection<String> getClassNames() {
                return Collections.emptyList();
            }
        };
        this.logger = Agent.LOG.getChildLogger(ClassTransformer.class);
    }

    protected boolean isCoreLibrary(String className) {
        return className.startsWith("java") || className.startsWith("sun") || className.startsWith("com/sun");
    }

    @Override
    public void start(InstrumentationProxy instrumentation, boolean isRetransformSupported) {
        instrumentation.addTransformer(this, isRetransformSupported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (this.classMatcher.isMatch(loader, className, null)) {
                this.logger.finer("Evaluating classloader:" + className);
                try {
                    ClassReader cr = new ClassReader(new ByteArrayInputStream(classfileBuffer));
                    ClassWriter cw = InstrumentationUtils.getClassWriter(cr, loader);
                    ClassLoaderClassVisitor classAdapter = new ClassLoaderClassVisitor((ClassVisitor)cw);
                    cr.accept(classAdapter, this.classReaderFlags);
                    if (!classAdapter.isMatch()) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    this.logger.finer("Patched classloader:" + className);
                    byte[] byArray = cw.toByteArray();
                    return byArray;
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Error instrumenting \"{0}\": {1}", className, e);
                    this.logger.finer(msg);
                }
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    private class ClassLoaderClassVisitor
    extends ClassVisitor {
        private boolean match;

        public ClassLoaderClassVisitor(ClassVisitor cv) {
            super(262144, cv);
        }

        public boolean isMatch() {
            return this.match;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if ("loadClass".equals(name) && METHOD_DESCRIPTIONS_TO_MATCH.contains(desc)) {
                this.match = true;
                mv = new GeneratorAdapter(mv, access, name, desc){

                    public void visitCode() {
                        super.visitCode();
                        this.loadArg(0);
                        this.mv.visitLdcInsn("com.newrelic");
                        this.mv.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z");
                        Label l1 = new Label();
                        this.mv.visitJumpInsn(153, l1);
                        this.mv.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;");
                        this.loadArg(0);
                        this.mv.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;");
                        this.mv.visitInsn(176);
                        this.mv.visitLabel(l1);
                    }
                };
            }
            return mv;
        }
    }
}

