/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.instrumentation.AbstractImplementationClassTransformer;
import com.newrelic.agent.instrumentation.AddInterfaceAdapter;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.FieldAccessorGeneratingClassAdapter;
import com.newrelic.agent.instrumentation.RequireMethodsAdapter;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.NoMatchMatcher;
import com.newrelic.agent.instrumentation.pointcuts.database.PreparedStatementExtension;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCClassTransformer
extends AbstractImplementationClassTransformer {
    public static final String DERBY_PREPARED_STATEMENT = "org/apache/derby/impl/jdbc/EmbedPreparedStatement";
    private static final List<String> DEFAULT_JDBC_STATEMENT_CLASSES = Arrays.asList("org/apache/derby/impl/jdbc/EmbedPreparedStatement", "com/mysql/jdbc/PreparedStatement", "com/microsoft/sqlserver/jdbc/SQLServerPreparedStatement", "net/sourceforge/jtds/jdbc/JtdsPreparedStatement", "oracle/jdbc/driver/OraclePreparedStatementWrapper", "org/postgresql/jdbc2/AbstractJdbc2Statement", "oracle/jdbc/driver/OraclePreparedStatement");
    private boolean genericJdbcSupportEnabled = true;

    public JDBCClassTransformer(ClassTransformer classTransformer) {
        super(classTransformer, true, PreparedStatementExtension.class, JDBCClassTransformer.getJdbcStatementClassMatcher(), NoMatchMatcher.MATCHER, "java/sql/PreparedStatement");
    }

    private static ClassMatcher getJdbcStatementClassMatcher() {
        StringBuilder sb = new StringBuilder();
        sb.append("JDBC statement classes: ");
        Set<String> jdbcClasses = JDBCClassTransformer.getJdbcStatementClasses();
        for (String jdbcClass : jdbcClasses) {
            sb.append("\n").append(jdbcClass);
        }
        Agent.LOG.fine(sb.toString());
        return ExactClassMatcher.or(jdbcClasses.toArray(new String[0]));
    }

    public static Set<String> getJdbcStatementClasses() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(DEFAULT_JDBC_STATEMENT_CLASSES);
        result.addAll(JDBCClassTransformer.getJdbcStatementClassesInConfig());
        return Collections.unmodifiableSet(result);
    }

    private static List<String> getJdbcStatementClassesInConfig() {
        LinkedList<String> result = new LinkedList<String>();
        ClassTransformerConfig config = ServiceFactory.getConfigService().getAgentConfig().getClassTransformerConfig();
        for (String configClass : config.getJdbcStatements()) {
            result.add(configClass);
        }
        return result;
    }

    @Override
    protected ClassVisitor createClassVisitor(ClassReader cr, ClassWriter cw, String className, ClassLoader loader) {
        ClassVisitor adapter = new AddInterfaceAdapter(cw, className, PreparedStatementExtension.class);
        adapter = RequireMethodsAdapter.getRequireMethodsAdaptor(adapter, className, PreparedStatementExtension.class, loader);
        adapter = new FieldAccessorGeneratingClassAdapter(adapter, className, PreparedStatementExtension.class);
        return adapter;
    }

    @Override
    protected boolean isGenericInterfaceSupportEnabled() {
        return this.genericJdbcSupportEnabled;
    }
}

