/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class InstrumentUtils {
    private InstrumentUtils() {
    }

    public static String getURI(URI theUri) {
        if (theUri == null) {
            return "";
        }
        return InstrumentUtils.getURI(theUri.getScheme(), theUri.getHost(), theUri.getPort(), theUri.getPath());
    }

    public static String getURI(URL theUrl) {
        if (theUrl == null) {
            return "";
        }
        try {
            return InstrumentUtils.getURI(theUrl.toURI());
        }
        catch (URISyntaxException e) {
            return InstrumentUtils.getURI(theUrl.getProtocol(), theUrl.getHost(), theUrl.getPort(), theUrl.getPath());
        }
    }

    public static String getURI(String scheme, String host, int port, String path) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme);
            sb.append("://");
        }
        if (host != null) {
            sb.append(host);
            if (port >= 0) {
                sb.append(":");
                sb.append(port);
            }
        }
        if (path != null) {
            sb.append(path);
        }
        return sb.toString();
    }
}

