/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.instrumentation.AbstractTracingMethodAdapter;
import com.newrelic.agent.instrumentation.BootstrapClassMethodAdapter;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InvocationHandlerTracingMethodAdapter;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PrimitiveConverter;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.TraceAnnotationInfo;
import com.newrelic.agent.instrumentation.classmatchers.AnnotationMatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericClassAdapter
extends ClassVisitor {
    static final String OBJECT_FIELD_NAME = "nextUniqueNumberLock";
    static final String AGENT_HANDLE_CLASS_NAME = "java.lang.reflect.Proxy";
    private static final int MAX_VERSION = 51;
    private static final String CLINIT_METHOD_NAME = "<clinit>";
    private static final String NO_ARG_VOID_DESC = "()V";
    private static final String INIT_CLASS_METHOD_NAME = "__nr__initClass";
    private final String className;
    private final Collection<PointCut> strongMatchPointCuts;
    private final Collection<PointCut> weakMatchPointCuts;
    private final Set<String> visibleAnnotations;
    private final ClassLoader classLoader;
    final Class<?> classBeingRedefined;
    private boolean firstMethod = true;
    private final boolean customTracingDisabled;
    private final List<AbstractTracingMethodAdapter> instrumentedMethods = new ArrayList<AbstractTracingMethodAdapter>();
    private int version;
    private boolean processedClassInitMethod;

    public GenericClassAdapter(ClassVisitor cv, ClassLoader classLoader, String className, Class<?> classBeingRedefined, Collection<PointCut> strongMatches, Collection<PointCut> possibleMatches) {
        super(262144, cv);
        this.customTracingDisabled = !ServiceFactory.getConfigService().getAgentConfig().isCustomTracingEnabled();
        this.visibleAnnotations = new HashSet<String>();
        this.classLoader = classLoader;
        this.className = className;
        this.strongMatchPointCuts = strongMatches;
        this.weakMatchPointCuts = possibleMatches;
        this.classBeingRedefined = classBeingRedefined;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean isInterface;
        boolean bl = isInterface = (access & 0x200) != 0;
        if (isInterface) {
            throw new StopProcessingException(name + " is an interface");
        }
        super.visit(version, access, name, signature, superName, interfaces);
        this.version = version;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible) {
            this.visibleAnnotations.add(desc);
        }
        return super.visitAnnotation(desc, visible);
    }

    boolean useInvocationHandlerFields() {
        return null != this.classLoader || null == this.classBeingRedefined;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Collection<PointCut> strong;
        List weak;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.useInvocationHandlerFields() && CLINIT_METHOD_NAME.equals(name)) {
            mv = new InitMethodAdapter(mv, access, name, desc);
            this.processedClassInitMethod = true;
            return mv;
        }
        if ((access & 0x400) != 0) {
            return mv;
        }
        if (this.firstMethod) {
            this.processClassAnnotations();
            this.firstMethod = false;
        }
        Collection<Object> collection = weak = (strong = this.matches(this.strongMatchPointCuts, access, name, desc, signature, exceptions)).isEmpty() ? this.matches(this.weakMatchPointCuts, access, name, desc, signature, exceptions) : Collections.EMPTY_LIST;
        if (strong.isEmpty() && weak.isEmpty() && (this.customTracingDisabled || null != this.classBeingRedefined)) {
            return mv;
        }
        if (this.useInvocationHandlerFields()) {
            return new InvocationHandlerTracingMethodAdapter(this, mv, access, this.className, this.classBeingRedefined, name, desc, !strong.isEmpty() || !weak.isEmpty());
        }
        PointCut pointCut = strong.iterator().next();
        PointCutInvocationHandler pointCutInvocationHandler = pointCut.getPointCutInvocationHandler();
        int id = ServiceFactory.getTracerService().getInvocationHandlerId(pointCutInvocationHandler);
        return new BootstrapClassMethodAdapter(this, mv, access, this.className, this.classBeingRedefined, name, desc, id);
    }

    private void processClassAnnotations() {
        for (PointCut pc : this.weakMatchPointCuts.toArray(new PointCut[0])) {
            if (!(pc.getClassMatcher() instanceof AnnotationMatcher)) continue;
            if (((AnnotationMatcher)((Object)pc.getClassMatcher())).matches(this.visibleAnnotations)) {
                this.strongMatchPointCuts.add(pc);
            }
            this.weakMatchPointCuts.remove(pc);
        }
    }

    private Collection<PointCut> matches(Collection<PointCut> pointcuts, int access, String name, String desc, String signature, String[] exceptions) {
        LinkedList<PointCut> pcs = new LinkedList<PointCut>();
        for (PointCut pc : pointcuts) {
            if (!pc.getMethodMatcher().matches(name, desc)) continue;
            pcs.add(pc);
        }
        return pcs;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.useInvocationHandlerFields() && (this.processedClassInitMethod || this.instrumentedMethods.size() > 0)) {
            this.createNRClassInitMethod();
        }
        if (this.instrumentedMethods.size() > 0) {
            if (null != this.classLoader) {
                this.cv.visitAnnotation(Type.getDescriptor(InstrumentedClass.class), true);
            }
            if (this.useInvocationHandlerFields()) {
                this.createInvocationHandlerFields();
                if (!this.processedClassInitMethod) {
                    this.createClassInitMethod();
                }
            }
        }
    }

    private void createClassInitMethod() {
        MethodVisitor mv = this.cv.visitMethod(8, CLINIT_METHOD_NAME, NO_ARG_VOID_DESC, null, null);
        mv = new InitMethodAdapter(mv, 8, CLINIT_METHOD_NAME, NO_ARG_VOID_DESC);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createNRClassInitMethod() {
        MethodVisitor mv = this.cv.visitMethod(8, INIT_CLASS_METHOD_NAME, NO_ARG_VOID_DESC, null, null);
        mv = new InitMethod(mv, 8, INIT_CLASS_METHOD_NAME, NO_ARG_VOID_DESC);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createInvocationHandlerFields() {
        for (AbstractTracingMethodAdapter methodAdapter : this.instrumentedMethods) {
            String fieldName = methodAdapter.getInvocationHandlerFieldName();
            if (fieldName == null) continue;
            this.cv.visitField(10, fieldName, InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_TYPE.getDescriptor(), null, null);
        }
    }

    int addInstrumentedMethod(AbstractTracingMethodAdapter methodAdapter) {
        int index = this.instrumentedMethods.size();
        this.instrumentedMethods.add(methodAdapter);
        return index;
    }

    public Collection<AbstractTracingMethodAdapter> getInstrumentedMethods() {
        return this.instrumentedMethods;
    }

    private class InitMethod
    extends AdviceAdapter {
        private InitMethod(MethodVisitor mv, int access, String name, String desc) {
            super(262144, mv, access, name, desc);
        }

        private int getAgentWrapper() {
            int fieldVar = this.newLocal(Type.getType(Field.class));
            this.mv.visitLdcInsn(GenericClassAdapter.AGENT_HANDLE_CLASS_NAME);
            this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            int proxyClassVar = this.newLocal(Type.getType(Class.class));
            this.mv.visitVarInsn(58, proxyClassVar);
            this.mv.visitVarInsn(25, proxyClassVar);
            this.mv.visitLdcInsn(GenericClassAdapter.OBJECT_FIELD_NAME);
            this.mv.visitMethodInsn(182, "java/lang/Class", "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            this.mv.visitVarInsn(58, fieldVar);
            this.mv.visitVarInsn(25, fieldVar);
            this.mv.visitInsn(4);
            this.mv.visitMethodInsn(182, "java/lang/reflect/Field", "setAccessible", "(Z)V");
            this.mv.visitVarInsn(25, fieldVar);
            this.mv.visitVarInsn(25, proxyClassVar);
            this.mv.visitMethodInsn(182, "java/lang/reflect/Field", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            this.mv.visitTypeInsn(192, InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_TYPE.getInternalName());
            int invocationHandlerVar = this.newLocal(InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_TYPE);
            this.mv.visitVarInsn(58, invocationHandlerVar);
            return invocationHandlerVar;
        }

        protected void onMethodEnter() {
            int invocationHandlerVar = this.getAgentWrapper();
            if (this.isNecessaryToLoadClassWithForName()) {
                this.mv.visitLdcInsn(Type.getObjectType(GenericClassAdapter.this.className).getClassName());
                this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            } else {
                this.visitLdcInsn(Type.getObjectType(GenericClassAdapter.this.className));
            }
            int classVar = this.newLocal(Type.getType(Object.class));
            this.mv.visitVarInsn(58, classVar);
            for (AbstractTracingMethodAdapter methodAdapter : GenericClassAdapter.this.instrumentedMethods) {
                if (methodAdapter.getInvocationHandlerFieldName() == null) continue;
                this.initMethod(classVar, invocationHandlerVar, methodAdapter);
            }
        }

        private boolean isNecessaryToLoadClassWithForName() {
            return GenericClassAdapter.this.version < 49 || GenericClassAdapter.this.version > 51;
        }

        private void initMethod(int classVar, int invocationHandlerVar, AbstractTracingMethodAdapter methodAdapter) {
            this.mv.visitVarInsn(25, invocationHandlerVar);
            this.mv.visitVarInsn(25, classVar);
            this.visitInsn(1);
            ArrayList<Object> arguments = new ArrayList<Object>(Arrays.asList(methodAdapter.className, methodAdapter.methodName, methodAdapter.getMethodDesc(), PrimitiveConverter.valueOf((GeneratorAdapter)this, methodAdapter.isIgnoreApdex()), PrimitiveConverter.valueOf((GeneratorAdapter)this, methodAdapter.isIgnoreTransaction())));
            TraceAnnotationInfo annotationInfo = methodAdapter.getTraceAnnotationInfo();
            if (annotationInfo != null) {
                arguments.addAll(Arrays.asList(annotationInfo.tracerFactoryName, annotationInfo.metricName, PrimitiveConverter.valueOf((GeneratorAdapter)this, annotationInfo.dispatcher), PrimitiveConverter.valueOf((GeneratorAdapter)this, annotationInfo.skipTransactionTrace)));
            }
            this.loadObjectArray(arguments.toArray(new Object[arguments.size()]));
            this.invokeInterface(InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_TYPE, InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_INVOKE_METHOD);
            this.mv.visitTypeInsn(192, InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_TYPE.getInternalName());
            this.mv.visitFieldInsn(179, methodAdapter.className, methodAdapter.getInvocationHandlerFieldName(), InvocationHandlerTracingMethodAdapter.INVOCATION_HANDLER_TYPE.getDescriptor());
        }

        protected void loadObjectArray(Object ... objects) {
            if (objects == null || objects.length == 0) {
                this.visitInsn(1);
                return;
            }
            this.push(objects.length);
            Type objectType = Type.getObjectType("java/lang/Object");
            this.newArray(objectType);
            for (int i = 0; i < objects.length; ++i) {
                this.dup();
                this.push(i);
                if (objects[i] == null) {
                    this.visitInsn(1);
                } else if (objects[i] instanceof Runnable) {
                    ((Runnable)objects[i]).run();
                } else {
                    this.mv.visitLdcInsn(objects[i]);
                }
                this.box(objectType);
                this.arrayStore(objectType);
            }
        }
    }

    private class InitMethodAdapter
    extends AdviceAdapter {
        protected InitMethodAdapter(MethodVisitor mv, int access, String name, String desc) {
            super(262144, mv, access, name, desc);
        }

        protected void onMethodEnter() {
            this.mv.visitMethodInsn(184, GenericClassAdapter.this.className, GenericClassAdapter.INIT_CLASS_METHOD_NAME, GenericClassAdapter.NO_ARG_VOID_DESC);
        }
    }
}

