/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.NonUrlClassLoaders;
import com.newrelic.agent.service.ServiceFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassloaderJarExtractor {
    private static final Integer ONE = 1;
    private final Map<String, Integer> classLoadersToUrlCount = new HashMap<String, Integer>();
    private final Map<String, Integer> nonURLClassLoaders = new HashMap<String, Integer>();

    public void grabJarInformation(ClassLoader loader) {
        try {
            if (loader != null) {
                String loaderName;
                NonUrlClassLoaders loaderType;
                if (loader instanceof URLClassLoader) {
                    this.handlerURLClassLoader(loader);
                } else if (this.isNewLoader(loader) && (loaderType = NonUrlClassLoaders.getNonUrlType(loaderName = loader.getClass().getCanonicalName())) != null) {
                    switch (loaderType) {
                        case JBOSS_6: {
                            this.handleJboss6(loader);
                            break;
                        }
                        case JBOSS_7: {
                            this.handlerJboss7(loader);
                            break;
                        }
                        case WEBSHPERE_8: {
                            this.handleWebshpere8(loader);
                            break;
                        }
                        case WEBLOGIC: {
                            this.handleWeblogic(loader);
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, "Unable to load 3rd party jar information from class loader. Jars loaded by this class loader will not be reported to New Relic.");
            Agent.LOG.log(Level.FINER, "Error when attempting to load jars. ", e);
        }
    }

    private boolean isNewLoader(ClassLoader loader) {
        String key;
        Integer count;
        if (!"sun.reflect.DelegatingClassLoader".equals(loader.getClass().getCanonicalName()) && (count = this.nonURLClassLoaders.get(key = String.valueOf(loader.hashCode()))) == null) {
            this.nonURLClassLoaders.put(key, ONE);
            return true;
        }
        return false;
    }

    private Object callPublicMethod(Object loader, String method) {
        try {
            Method theMethod = loader.getClass().getDeclaredMethod(method, new Class[0]);
            if (theMethod != null) {
                return theMethod.invoke(loader, new Object[0]);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("Exception when trying to invoke {0} on {1}.", method, loader.getClass()), e);
        }
        return null;
    }

    private Object callRestrictedMethod(ClassLoader loader, String method) {
        try {
            Method theMethod = loader.getClass().getMethod(method, new Class[0]);
            if (theMethod != null) {
                theMethod.setAccessible(true);
                return theMethod.invoke((Object)loader, new Object[0]);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("Exception when trying to invoke {0} on {1}.", method, loader.getClass()), e);
        }
        return null;
    }

    private Object getRestrictedField(Object objWithField, String fieldName) {
        try {
            Field field = objWithField.getClass().getDeclaredField(fieldName);
            if (field != null) {
                field.setAccessible(true);
                return field.get(objWithField);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("Exception when trying to grab field {0} on {1}.", fieldName, objWithField.getClass()), e);
        }
        return null;
    }

    private void handleWeblogic(ClassLoader loader) {
        Object stringParamsObject = this.callRestrictedMethod(loader, "getClassPath");
        if (stringParamsObject != null) {
            String classPath = stringParamsObject.toString();
            String[] jars = classPath.split(":");
            ServiceFactory.getModuleService().addFilePaths(jars);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, MessageFormat.format("Found new weblogic classloader of type {0}.", loader.getClass()));
            }
        }
    }

    private void handleWebshpere8(ClassLoader loader) {
        Object pathsObject = this.callRestrictedMethod(loader, "getPaths");
        if (pathsObject != null && pathsObject instanceof String[]) {
            String[] paths = (String[])pathsObject;
            ServiceFactory.getModuleService().addFilePaths(paths);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, MessageFormat.format("Found new webshpere classloader of type {0}.", loader.getClass()));
            }
        }
    }

    private void handlerJboss7(ClassLoader loader) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object paths;
        ArrayList<URL> urls = new ArrayList<URL>();
        Object module = this.callPublicMethod(loader, "getModule");
        if (module != null && "org.jboss.modules.Module".equals(module.getClass().getCanonicalName()) && (paths = this.callPublicMethod(module, "getExportedPaths")) != null && paths instanceof Set) {
            this.processJboss7Paths((Set)paths, module, urls);
            if (!urls.isEmpty()) {
                ServiceFactory.getModuleService().addUrls(urls.toArray(new URL[urls.size()]));
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.FINEST, MessageFormat.format("Found new jboss 7 classloader of type {0}.", loader.getClass()));
                }
            }
        }
    }

    private void processJboss7Paths(Set<String> paths, Object module, List<URL> urls) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method exportedResource = module.getClass().getMethod("getExportedResources", String.class);
        String last = null;
        for (String current : paths) {
            if (last != null && (current.startsWith(last) || last.startsWith(current))) continue;
            last = current;
            Object urlObject = exportedResource.invoke(module, current);
            if (urlObject == null) continue;
            Enumeration allURLS = (Enumeration)urlObject;
            while (allURLS.hasMoreElements()) {
                urls.add((URL)allURLS.nextElement());
            }
        }
    }

    private void handleJboss6(ClassLoader loader) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object[] files;
        Object virtualFiles;
        Object classLoaderPolicy = this.getRestrictedField(loader, "policy");
        if (classLoaderPolicy != null && (virtualFiles = this.getRestrictedField(classLoaderPolicy, "roots")) != null && virtualFiles instanceof Object[] && (files = (Object[])virtualFiles).length > 0) {
            URL[] urls = new URL[files.length];
            Method getUrlMethod = files[0].getClass().getMethod("toURL", new Class[0]);
            for (int i = 0; i < files.length; ++i) {
                urls[i] = (URL)getUrlMethod.invoke(files[i], new Object[0]);
            }
            ServiceFactory.getModuleService().addUrls(urls);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, MessageFormat.format("Found new jboss 6 classloader of type {0}.", loader.getClass()));
            }
        }
    }

    private void handlerURLClassLoader(ClassLoader loader) {
        URLClassLoader urlLoader = (URLClassLoader)loader;
        String stringValue = String.valueOf(urlLoader.hashCode());
        URL[] urls = urlLoader.getURLs();
        Integer count = this.classLoadersToUrlCount.get(stringValue);
        if (urls != null && (count == null || urls.length > count)) {
            ServiceFactory.getModuleService().addUrls(urls);
            this.classLoadersToUrlCount.put(stringValue, urls.length);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, MessageFormat.format("Found new URL classloader with hashcode {0} of type {1}.", stringValue, loader.getClass()));
            }
        }
    }
}

