/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.TracerService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.instrumentation.AbstractTracingMethodAdapter;
import com.newrelic.agent.instrumentation.AgentWrapper;
import com.newrelic.agent.instrumentation.ClassLoaderCheck;
import com.newrelic.agent.instrumentation.ClassNameFilter;
import com.newrelic.agent.instrumentation.ClassloaderJarExtractor;
import com.newrelic.agent.instrumentation.GenericClassAdapter;
import com.newrelic.agent.instrumentation.IgnoreApdexInvocationHandler;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InvocationPoint;
import com.newrelic.agent.instrumentation.NoOpInvocationHandler;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.TraceAnnotationInfo;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.CustomTracerFactory;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.util.Annotations;
import com.newrelic.agent.util.Invoker;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassWriter;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTransformer
implements StartableClassFileTransformer {
    private final Collection<PointCut> pointcuts;
    private final int classreaderFlags;
    private final InstrumentationProxy instrumentation;
    private final boolean retransformSupported;
    private final ClassNameFilter classNameFilter;
    private final IAgentLogger logger;
    private final ClassloaderJarExtractor jarExtractor = new ClassloaderJarExtractor();

    protected ClassTransformer(InstrumentationProxy instrumentation, boolean retransformSupported) {
        this.instrumentation = instrumentation;
        this.logger = Agent.LOG.getChildLogger(ClassTransformer.class);
        this.initAgentHandle();
        this.classNameFilter = new ClassNameFilter(this.logger);
        AgentConfig config = ServiceFactory.getConfigService().getAgentConfig();
        this.classNameFilter.addConfigClassFilters(config);
        this.classNameFilter.addExcludeFileClassFilters();
        this.classreaderFlags = instrumentation.getClassReaderFlags();
        this.retransformSupported = retransformSupported;
        LinkedList<PointCut> pcs = new LinkedList<PointCut>(this.findEnabledPointCuts());
        pcs.addAll(ServiceFactory.getExtensionService().getEnabledPointCuts());
        pcs.addAll(ErrorService.getEnabledErrorHandlerPointCuts());
        Collections.sort(pcs);
        this.pointcuts = Collections.unmodifiableCollection(pcs);
        ArrayList<PointCutInvocationHandler> handlers = new ArrayList<PointCutInvocationHandler>(pcs.size());
        ArrayList<ClassMatcher> classMatchers = new ArrayList<ClassMatcher>();
        for (PointCut pc : this.pointcuts) {
            handlers.add(pc.getPointCutInvocationHandler());
            classMatchers.add(pc.getClassMatcher());
        }
        this.classNameFilter.addClassMatcherIncludes(classMatchers);
        ServiceFactory.getTracerService().registerInvocationHandlers(handlers);
        this.logger.finer("Class transformer initialized");
    }

    private void initAgentHandle() {
        try {
            Class<?> magicClass = Class.forName("java.lang.reflect.Proxy");
            Field proxyClassesField = magicClass.getDeclaredField("nextUniqueNumberLock");
            proxyClassesField.setAccessible(true);
            proxyClassesField.set(magicClass, AgentWrapper.getAgentWrapper(this));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize the agent handle", e);
        }
    }

    Collection<PointCut> findEnabledPointCuts() {
        Collection<Class> classes = Annotations.getAnnotationClasses(com.newrelic.agent.instrumentation.pointcuts.PointCut.class, "com/newrelic/agent/instrumentation/pointcuts");
        ArrayList<PointCut> pointcuts = new ArrayList<PointCut>();
        for (Class clazz : classes) {
            PointCut pc = this.createPointCut(clazz);
            if (!pc.isEnabled()) continue;
            pointcuts.add(pc);
        }
        return pointcuts;
    }

    private PointCut createPointCut(Class<PointCut> clazz) {
        try {
            return clazz.getConstructor(ClassTransformer.class).newInstance(this);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to create pointcut {0} : {1}", clazz.getName(), e.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINE, msg, e);
            return null;
        }
    }

    @Override
    public void start(InstrumentationProxy instrumentation, boolean isRetransformSupported) {
        instrumentation.addTransformer(this, this.retransformSupported);
        for (PointCut pc : this.pointcuts) {
            pc.noticeTransformerStarted(this);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        this.jarExtractor.grabJarInformation(loader);
        if (!this.shouldTransform(loader, className, classfileBuffer)) {
            return null;
        }
        try {
            WeavingLoaderImpl weavingLoader = this.getWeavingLoader(loader);
            if (Agent.isDebugEnabled() && this.logger.isTraceEnabled()) {
                this.logger.trace(MessageFormat.format("Instrumenting class: {0}", className));
            }
            return weavingLoader.preProcess(className, classBeingRedefined, classfileBuffer);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.severe(MessageFormat.format("An error occurred processing class {0} : {1}", className, e.toString()));
            if (Agent.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private boolean shouldTransform(ClassLoader loader, String className, byte[] classfileBuffer) {
        boolean isLoggable;
        boolean bl = isLoggable = Agent.isDebugEnabled() && this.logger.isLoggable(Level.FINEST);
        if (this.isExcluded(className)) {
            if (isLoggable) {
                // empty if block
            }
            return false;
        }
        if (className.startsWith("$")) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("Skipping class {0} because it starts with $", className));
            }
            return false;
        }
        if (className.indexOf("$$") > 0) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("Skipping class {0} because it contains $$", className));
            }
            return false;
        }
        if (this.isValidClassByteArray(classfileBuffer)) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("Skipping class {0} because it does not appear to be a valid class file", className));
            }
            return false;
        }
        if (loader == null && !this.isBootstrapClassInstrumentationEnabled()) {
            if (isLoggable) {
                this.logger.finest(MessageFormat.format("Skipping class {0} because bootstrap class instrumentation is not supported", className));
            }
            return false;
        }
        return true;
    }

    private boolean isBootstrapClassInstrumentationEnabled() {
        return this.instrumentation.isBootstrapClassInstrumentationEnabled();
    }

    protected boolean isExcluded(String className) {
        return !this.classNameFilter.isIncluded(className) && this.classNameFilter.isExcluded(className);
    }

    private boolean isValidClassByteArray(byte[] classfileBuffer) {
        return classfileBuffer.length >= 4 && classfileBuffer[0] == -54 && classfileBuffer[0] == -2 && classfileBuffer[0] == -70 && classfileBuffer[0] == -66;
    }

    protected int getClassReaderFlags() {
        return this.classreaderFlags;
    }

    private WeavingLoaderImpl getWeavingLoader(ClassLoader loader) {
        return new WeavingLoaderImpl(loader);
    }

    public void shutdown() {
    }

    InstrumentationProxy getInstrumentation() {
        return this.instrumentation;
    }

    public final ClassNameFilter getClassNameFilter() {
        return this.classNameFilter;
    }

    public InvocationHandler evaluate(Class clazz, TracerService tracerService, Object className, Object methodName, Object methodDesc, boolean ignoreApdex, Object[] args) {
        ClassMethodSignature classMethodSignature = new ClassMethodSignature(((String)className).replace('/', '.'), (String)methodName, (String)methodDesc);
        if (args.length > 5) {
            TraceAnnotationInfo annotationInfo = new TraceAnnotationInfo();
            annotationInfo.tracerFactoryName = (String)args[5];
            annotationInfo.metricName = (String)args[6];
            annotationInfo.dispatcher = (Boolean)args[7];
            if (args.length > 8) {
                annotationInfo.skipTransactionTrace = (Boolean)args[8];
            }
            classMethodSignature = classMethodSignature.intern();
            if (this.logger.isFinerEnabled()) {
                String dispatcher = annotationInfo.dispatcher ? "dispatcher " : "";
                String noTransactionTrace = annotationInfo.skipTransactionTrace ? "skip transaction trace " : "";
                this.logger.finer(MessageFormat.format("custom {0}{1}tracer on: {2}.{3}{4}", dispatcher, noTransactionTrace, classMethodSignature.getClassName(), classMethodSignature.getMethodName(), classMethodSignature.getMethodDesc()));
            }
            return new InvocationPoint(tracerService, classMethodSignature, new CustomTracerFactory(classMethodSignature, annotationInfo), ignoreApdex);
        }
        for (PointCut pc : this.pointcuts) {
            if (!pc.getClassMatcher().isMatch(clazz) || !pc.getMethodMatcher().matches(classMethodSignature.getMethodName(), classMethodSignature.getMethodDesc())) continue;
            PointCutInvocationHandler invocationHandler = pc.getPointCutInvocationHandler();
            return InvocationPoint.getInvocationPoint(invocationHandler, tracerService, classMethodSignature, ignoreApdex);
        }
        if (ignoreApdex) {
            return IgnoreApdexInvocationHandler.INVOCATION_HANDLER;
        }
        return NoOpInvocationHandler.INVOCATION_HANDLER;
    }

    public static boolean isInstrumented(Class<?> clazz) {
        if (clazz.getAnnotation(InstrumentedClass.class) != null) {
            return true;
        }
        try {
            clazz.getDeclaredField(AbstractTracingMethodAdapter.getInvocationHandlerFieldName(0));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeavingLoaderImpl {
        private final ClassLoader classLoader;

        public WeavingLoaderImpl(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public byte[] preProcess(String className, Class<?> classBeingRedefined, byte[] classfileBuffer) {
            InstrumentedClass annotation;
            if (classBeingRedefined != null && (annotation = classBeingRedefined.getAnnotation(InstrumentedClass.class)) != null) {
                return null;
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            if (InstrumentationUtils.isInterface(cr)) {
                return null;
            }
            Collection<PointCut> nonMatchers = this.getNonMatchingPointCuts(className, cr, classBeingRedefined);
            LinkedList<PointCut> possibleMatches = new LinkedList<PointCut>(ClassTransformer.this.pointcuts);
            possibleMatches.removeAll(nonMatchers);
            if (possibleMatches.isEmpty() && !ServiceFactory.getConfigService().getAgentConfig().isCustomTracingEnabled()) {
                return null;
            }
            Collection<PointCut> strongMatches = this.getMatchingPointCuts(possibleMatches, className, cr, classBeingRedefined);
            possibleMatches.removeAll(strongMatches);
            if (classBeingRedefined != null && strongMatches.isEmpty()) {
                return null;
            }
            if (this.classLoader != null && !InstrumentationUtils.isAbleToResolveAgent(this.classLoader, className)) {
                String msg = MessageFormat.format("Not instrumenting {0}: class loader unable to load agent classes", className);
                Agent.LOG.log(Level.FINER, msg);
                return null;
            }
            try {
                byte[] classfileBufferWithUID = InstrumentationUtils.generateClassBytesWithSerialVersionUID(cr, ClassTransformer.this.classreaderFlags, this.classLoader);
                ClassReader crWithUID = new ClassReader(classfileBufferWithUID);
                ClassWriter cwWithUID = InstrumentationUtils.getClassWriter(crWithUID, this.classLoader);
                GenericClassAdapter adapter = new GenericClassAdapter(cwWithUID, this.classLoader, className, classBeingRedefined, strongMatches, possibleMatches);
                crWithUID.accept(adapter, ClassTransformer.this.classreaderFlags);
                if (adapter.getInstrumentedMethods().size() > 0) {
                    return cwWithUID.toByteArray();
                }
                return null;
            }
            catch (StopProcessingException e) {
                return null;
            }
            catch (ArrayIndexOutOfBoundsException t) {
                String msg = MessageFormat.format("Skipping transformation of class {0} ({1} bytes) because an ASM array bounds exception occurred: {2}", className, classfileBuffer.length, t.toString());
                ClassTransformer.this.logger.warning(msg);
                if (ClassTransformer.this.logger.isLoggable(Level.FINER)) {
                    msg = MessageFormat.format("ASM error for pointcut(s) : strong {0} / weak {1}", strongMatches, possibleMatches);
                    ClassTransformer.this.logger.finer(msg);
                    ClassTransformer.this.logger.log(Level.FINER, "ASM error", t);
                }
                if (Boolean.getBoolean("newrelic.asm.error.stop")) {
                    System.exit(-1);
                }
                return null;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                ClassTransformer.this.logger.warning(MessageFormat.format("Skipping transformation of class {0} because an error occurred: {1}", className, t.toString()));
                if (ClassTransformer.this.logger.isLoggable(Level.FINER)) {
                    ClassTransformer.this.logger.log(Level.FINER, "Error transforming class " + className, t);
                }
                return null;
            }
        }

        private boolean isAbleToResolveAgent(ClassLoader loader) {
            try {
                ClassLoaderCheck.loadAgentClass(loader);
                return true;
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("Classloader {0} failed to load Agent class. The agent might need to be loaded by the bootstrap classloader.: {1}", loader.getClass().getName(), t);
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, t);
                } else if (Agent.LOG.isLoggable(Level.FINER)) {
                    Agent.LOG.finer(msg);
                }
                return false;
            }
        }

        private Collection<PointCut> getMatchingPointCuts(Collection<PointCut> possibleMatches, String className, ClassReader cr, Class<?> classBeingRedefined) {
            LinkedList<PointCut> cuts = new LinkedList<PointCut>();
            for (PointCut pc : possibleMatches) {
                if ((classBeingRedefined == null || !pc.getClassMatcher().isMatch(classBeingRedefined)) && !pc.getClassMatcher().isMatch(this.classLoader, className, cr)) continue;
                cuts.add(pc);
            }
            return cuts;
        }

        private Collection<PointCut> getNonMatchingPointCuts(String className, ClassReader cr, Class<?> classBeingRedefined) {
            LinkedList<PointCut> cuts = new LinkedList<PointCut>();
            for (PointCut pc : ClassTransformer.this.pointcuts) {
                if (!pc.getClassMatcher().isNotMatch(this.classLoader, className, cr, classBeingRedefined)) continue;
                cuts.add(pc);
            }
            return cuts;
        }

        private synchronized void redefineClass(String className, byte[] classfileBuffer) {
            block7: {
                try {
                    ClassTransformer.this.instrumentation.redefineClasses(new ClassDefinition(this.classLoader.loadClass(Invoker.getClassNameFromInternalName(className)), classfileBuffer));
                }
                catch (ClassNotFoundException e) {
                    String msg = MessageFormat.format("An error occurred redefining class {0}: {1}", className, e);
                    if (ClassTransformer.this.logger.isLoggable(Level.FINEST)) {
                        ClassTransformer.this.logger.log(Level.FINEST, msg, e);
                    } else if (ClassTransformer.this.logger.isLoggable(Level.FINER)) {
                        ClassTransformer.this.logger.finer(msg);
                    }
                }
                catch (UnmodifiableClassException e) {
                    String msg = MessageFormat.format("An error occurred redefining class {0}: {1}", className, e);
                    if (ClassTransformer.this.logger.isLoggable(Level.FINEST)) {
                        ClassTransformer.this.logger.log(Level.FINEST, msg, e);
                    }
                    if (!ClassTransformer.this.logger.isLoggable(Level.FINER)) break block7;
                    ClassTransformer.this.logger.finer(msg);
                }
            }
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

