/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.FieldVisitor;
import com.newrelic.org.objectweb.asm.Label;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import java.util.regex.Pattern;

class ClassLoaderClassAdapter
extends ClassVisitor {
    static final Pattern CLASSLOADER_MATCHER_PATTERN = Pattern.compile("(org/apache/felix/framework/searchpolicy/ModuleImpl\\$ModuleClassLoader$)|(org/glassfish/web/loader/WebappClassLoader)|(oracle/classloader/PolicyClassLoader)");
    private static final String RENAMED_LOAD_CLASS_METHOD = "__nr_loadClass";
    boolean renamedLoadClassMethod = false;
    private final String className;
    private final String parentClassName;

    public ClassLoaderClassAdapter(ClassVisitor cv, String className, String parentClassName) {
        super(262144, cv);
        this.className = className;
        this.parentClassName = parentClassName;
    }

    public void visitEnd() {
        FieldVisitor fv = this.cv.visitField(10, "NR_CLASSLOADER", "Ljava/lang/ClassLoader;", null, null);
        fv.visitEnd();
        MethodVisitor mv = super.visitMethod(1, "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", "(Ljava/lang/String;)Ljava/lang/Class<*>;", new String[]{"java/lang/ClassNotFoundException"});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn("com.newrelic.agent");
        mv.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, this.className, "NR_CLASSLOADER", "Ljava/lang/ClassLoader;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;");
        mv.visitInsn(176);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        if (this.renamedLoadClassMethod) {
            mv.visitMethodInsn(182, this.className, RENAMED_LOAD_CLASS_METHOD, "(Ljava/lang/String;)Ljava/lang/Class;");
        } else {
            mv.visitMethodInsn(183, this.parentClassName, "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;");
        }
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<clinit>".equals(name)) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            final String className2 = this.className;
            mv = new MethodVisitor(262144, mv){

                public void visitCode() {
                    super.visitCode();
                    this.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;");
                    this.visitFieldInsn(179, className2, "NR_CLASSLOADER", "Ljava/lang/ClassLoader;");
                    this.visitEnd();
                }
            };
            return mv;
        }
        if ("loadClass".equals(name) && "(Ljava/lang/String;)Ljava/lang/Class;".equals(desc)) {
            name = RENAMED_LOAD_CLASS_METHOD;
            access = 2;
            this.renamedLoadClassMethod = true;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public static boolean matchesClass(String className) {
        boolean result = CLASSLOADER_MATCHER_PATTERN.matcher(className).matches();
        if (result) {
            Agent.LOG.finer("Evaluating class loader:" + className);
        }
        return result;
    }
}

