/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddInterfaceAdapter
extends ClassVisitor {
    private final String className;
    private final Class<?> type;

    public AddInterfaceAdapter(ClassVisitor cv, String className, Class<?> type) {
        super(262144, cv);
        this.className = className;
        this.type = type;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, this.addInterface(interfaces));
    }

    @Override
    public void visitEnd() {
        if (Agent.LOG.isFinerEnabled()) {
            String msg = MessageFormat.format("Appended {0} to {1}", this.type.getName(), this.className.replace('/', '.'));
            Agent.LOG.finer(msg);
        }
        super.visitEnd();
    }

    private String[] addInterface(String[] interfaces) {
        HashSet<String> list = new HashSet<String>(Arrays.asList(interfaces));
        list.add(Type.getType(this.type).getInternalName());
        return list.toArray(new String[list.size()]);
    }
}

