/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import com.newrelic.org.objectweb.asm.Type;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImplementationClassTransformer
implements StartableClassFileTransformer {
    protected final IAgentLogger logger = Agent.LOG.getChildLogger(ClassTransformer.class);
    protected final int classreaderFlags;
    protected final ClassTransformer classTransformer;
    private final ClassMatcher classMatcher;
    protected final Class interfaceToImplement;
    protected final String originalInterface;
    protected final Type originalInterfaceType;
    private final boolean enabled;
    private final ClassMatcher skipClassMatcher;

    public AbstractImplementationClassTransformer(ClassTransformer classTransformer, boolean enabled, Class interfaceToImplement, ClassMatcher classMatcher, ClassMatcher skipMatcher, String originalInterfaceName) {
        this.classMatcher = classMatcher;
        this.skipClassMatcher = skipMatcher;
        this.interfaceToImplement = interfaceToImplement;
        this.originalInterface = originalInterfaceName;
        this.originalInterfaceType = Type.getObjectType(this.originalInterface);
        this.enabled = enabled;
        this.classTransformer = classTransformer;
        this.classreaderFlags = classTransformer.getClassReaderFlags();
    }

    public AbstractImplementationClassTransformer(ClassTransformer classTransformer, boolean enabled, Class interfaceToImplement) {
        this(classTransformer, enabled, interfaceToImplement, AbstractImplementationClassTransformer.getClassMatcher(interfaceToImplement), AbstractImplementationClassTransformer.getSkipClassMatcher(interfaceToImplement), AbstractImplementationClassTransformer.getOriginalInterface(interfaceToImplement));
    }

    private static String getOriginalInterface(Class interfaceToImplement) {
        InterfaceMapper interfaceMapper = interfaceToImplement.getAnnotation(InterfaceMapper.class);
        return interfaceMapper.originalInterfaceName();
    }

    private static ClassMatcher getClassMatcher(Class interfaceToImplement) {
        InterfaceMapper interfaceMapper = interfaceToImplement.getAnnotation(InterfaceMapper.class);
        if (interfaceMapper.className().length == 0) {
            return new ExactClassMatcher(interfaceMapper.originalInterfaceName());
        }
        return ExactClassMatcher.or(interfaceMapper.className());
    }

    private static ClassMatcher getSkipClassMatcher(Class interfaceToImplement) {
        InterfaceMapper interfaceMapper = interfaceToImplement.getAnnotation(InterfaceMapper.class);
        return ExactClassMatcher.or(interfaceMapper.skip());
    }

    @Override
    public void start(InstrumentationProxy instrumentation, boolean isRetransformSupported) {
        if (this.enabled) {
            instrumentation.addTransformer(this, false);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean isLoggable = false;
        if (classBeingRedefined != null) {
            return null;
        }
        if (loader == null && Agent.class.getClassLoader() != null) {
            return null;
        }
        if (this.skipClassMatcher.isMatch(loader, className, null)) {
            return null;
        }
        boolean matches = this.classMatcher.isMatch(loader, className, null);
        try {
            ClassReader cr;
            if (!matches) {
                if (!this.isGenericInterfaceSupportEnabled()) {
                    return null;
                }
                if (this.excludeClass(className)) {
                    return null;
                }
            }
            if (InstrumentationUtils.isInterface(cr = new ClassReader(classfileBuffer))) {
                return null;
            }
            if (!matches && !this.matches(cr, this.originalInterface)) {
                return null;
            }
            if (!InstrumentationUtils.isAbleToResolveAgent(loader, className)) {
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String msg = MessageFormat.format("Not instrumenting {0}: class loader unable to load agent classes", className);
                    Agent.LOG.log(Level.FINER, msg);
                }
                return null;
            }
            if ("org/eclipse/jetty/server/Request".equals(className)) {
                className.hashCode();
            }
            byte[] classBytesWithUID = InstrumentationUtils.generateClassBytesWithSerialVersionUID(cr, this.classreaderFlags, loader);
            ClassReader crWithUID = new ClassReader(classBytesWithUID);
            ClassWriter cwWithUID = InstrumentationUtils.getClassWriter(crWithUID, loader);
            cr.accept(this.createClassVisitor(crWithUID, cwWithUID, className, loader), this.classreaderFlags);
            return cwWithUID.toByteArray();
        }
        catch (StopProcessingException e) {
            String msg = MessageFormat.format("Instrumentation aborted for {0} - {1} ", className, e);
            Agent.LOG.finer(msg);
            return null;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Instrumentation error for {0} - {1} ", className, t);
            Agent.LOG.finer(msg);
            return null;
        }
    }

    protected boolean excludeClass(String className) {
        return this.classTransformer.isExcluded(className);
    }

    protected boolean isGenericInterfaceSupportEnabled() {
        return true;
    }

    protected int getClassReaderFlags() {
        return this.classreaderFlags;
    }

    protected abstract ClassVisitor createClassVisitor(ClassReader var1, ClassWriter var2, String var3, ClassLoader var4);

    private boolean matches(ClassReader cr, String interfaceNameToMatch) {
        String[] interfaces = cr.getInterfaces();
        if (interfaces != null) {
            for (String interfaceName : interfaces) {
                if (!interfaceNameToMatch.equals(interfaceName)) continue;
                return true;
            }
        }
        return false;
    }
}

