/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.extension.beans.Extension;
import com.newrelic.agent.extension.beans.Instrumentation;
import com.newrelic.agent.extension.beans.Method;
import com.newrelic.agent.extension.beans.Pointcut;
import com.newrelic.agent.extension.util.MethodMapper;
import com.newrelic.agent.extension.util.MethodParameters;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactParamsMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrExactParamMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.ClassMethodNameFormatPointCut;
import com.newrelic.agent.instrumentation.yaml.MetricNameFormatFactory;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.agent.instrumentation.yaml.SimpleMetricNameFormatFactory;
import com.newrelic.agent.tracers.metricname.OtherTransSimpleMetricNameFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionConversionUtility {
    public static final String DEFAULT_CONFIG_DIRECTORY = "extensions";
    private static final int COUNT_FOR_EXACT_MATCHER = 1;

    private ExtensionConversionUtility() {
    }

    public static void validateExtensionAttributes(Extension extension) {
        if (extension == null) {
            throw new RuntimeException("There must be an extension to instrument new methods.\n");
        }
        if (extension.getName() == null || extension.getName().isEmpty()) {
            throw new RuntimeException("The extension must have a name attribute.\n");
        }
        if (extension.getVersion() < 0.0) {
            throw new RuntimeException(" The version number must be a double and must be greater than or equal to 0.\n");
        }
    }

    private static void validateInstrument(Instrumentation instrument) {
        if (instrument == null) {
            throw new RuntimeException("In order to provide instrumentation, there must be an instrument tag.\n");
        }
        List<Pointcut> pcs = instrument.getPointcut();
        if (pcs == null || pcs.isEmpty()) {
            throw new RuntimeException("A point cut tag is required to instrument a method.\n");
        }
    }

    public static List<PointCut> convertToPointCutsForValidation(Extension ext) {
        ArrayList<PointCut> pointCutsOut = new ArrayList<PointCut>();
        Instrumentation inst = ext.getInstrumentation();
        ExtensionConversionUtility.validateExtensionAttributes(ext);
        ExtensionConversionUtility.validateInstrument(inst);
        List<Pointcut> pcs = inst.getPointcut();
        String defaultMetricPrefix = ExtensionConversionUtility.createDefaultMetricPrefix(inst);
        HashMap<String, MethodMapper> classesToMethods = new HashMap<String, MethodMapper>();
        for (Pointcut pc : pcs) {
            pointCutsOut.add(ExtensionConversionUtility.createPointCut(pc, defaultMetricPrefix, ext.getName(), classesToMethods));
        }
        return pointCutsOut;
    }

    public static List<PointCut> convertToEnabledPointCuts(Collection<Extension> extensions) {
        ArrayList<PointCut> pointCutsOut = new ArrayList<PointCut>();
        if (extensions != null) {
            HashMap<String, MethodMapper> classesToMethods = new HashMap<String, MethodMapper>();
            for (Extension ext : extensions) {
                if (ext.isEnabled().booleanValue()) {
                    pointCutsOut.addAll(ExtensionConversionUtility.convertToEnabledPointCuts(ext.getInstrumentation(), ext.getName(), classesToMethods));
                    continue;
                }
                Agent.LOG.log(Level.WARNING, MessageFormat.format("Extension {0} is not enabled and so will not be instrumented.", ext.getName()));
            }
        }
        return pointCutsOut;
    }

    private static List<PointCut> convertToEnabledPointCuts(Instrumentation instrumentation, String extensionName, Map<String, MethodMapper> classesToMethods) {
        ArrayList<PointCut> pointCutsOut = new ArrayList<PointCut>();
        if (instrumentation != null) {
            String defaultMetricPrefix = ExtensionConversionUtility.createDefaultMetricPrefix(instrumentation);
            List<Pointcut> inCuts = instrumentation.getPointcut();
            if (inCuts != null && !inCuts.isEmpty()) {
                for (Pointcut cut : inCuts) {
                    try {
                        PointCut pc = ExtensionConversionUtility.createPointCut(cut, defaultMetricPrefix, extensionName, classesToMethods);
                        if (pc == null) continue;
                        ExtensionConversionUtility.logPointCutCreation(pc);
                        if (!pc.isEnabled()) continue;
                        pointCutsOut.add(pc);
                    }
                    catch (Exception e) {
                        String msg = MessageFormat.format("An error occurred reading in a pointcut in extension {0} : {1}", extensionName, e.toString());
                        Agent.LOG.log(Level.SEVERE, msg);
                        Agent.LOG.log(Level.FINER, msg, e);
                    }
                }
            } else {
                String msg = MessageFormat.format("There were no point cuts in the extension {0}.", extensionName);
                Agent.LOG.log(Level.INFO, msg);
            }
        }
        return pointCutsOut;
    }

    private static String createDefaultMetricPrefix(Instrumentation instrument) {
        String prefix;
        String metricPrefix = "Custom";
        if (instrument != null && (prefix = instrument.getMetricPrefix()) != null && !prefix.isEmpty()) {
            metricPrefix = prefix;
        }
        return metricPrefix;
    }

    private static void logPointCutCreation(PointCut pc) {
        String msg = MessageFormat.format("Extension instrumentation point: {0} {1}", pc.getClassMatcher(), pc.getMethodMatcher());
        Agent.LOG.finest(msg);
    }

    private static PointCut createPointCut(Pointcut cut, String metricPrefix, String pName, Map<String, MethodMapper> classesToMethods) {
        MetricNameFormatFactory nameFactory = ExtensionConversionUtility.createMetricNameFormat(cut, metricPrefix);
        ClassMatcher classMatcher = ExtensionConversionUtility.createClassMatcher(cut.getClassName(), pName);
        MethodMatcher methodMatcher = ExtensionConversionUtility.createMethodMatcher(cut, pName, classesToMethods);
        return new ClassMethodNameFormatPointCut(nameFactory, classMatcher, methodMatcher, cut.isTransactionStartPoint(), cut.isExcludeFromTransactionTrace(), cut.isIgnoreTransaction());
    }

    private static MetricNameFormatFactory createMetricNameFormat(Pointcut cut, String metricPrefix) {
        String nameFormat = cut.getMetricNameFormat();
        if (nameFormat == null || nameFormat.isEmpty()) {
            return new PointCutFactory.ClassMethodNameFormatDescriptor(metricPrefix, cut.isTransactionStartPoint());
        }
        return new SimpleMetricNameFormatFactory(new OtherTransSimpleMetricNameFormat(nameFormat.trim()));
    }

    private static MethodMatcher createMethodMatcher(Pointcut cut, String pExtName, Map<String, MethodMapper> classesToMethods) {
        List<Method> methods = cut.getMethod();
        if (methods == null || methods.isEmpty()) {
            throw new RuntimeException(MessageFormat.format("At least one method must be specified for each point cut in the extension {0}", pExtName));
        }
        if (methods.size() == 1) {
            Method method = methods.get(0);
            ExtensionConversionUtility.validateMethod(method, pExtName);
            return ExactParamsMethodMatcher.createExactParamsMethodMatcher(method.getName(), method.getParameters().getDescriptor(), cut.getClassName(), classesToMethods);
        }
        return OrExactParamMethodMatcher.createOrExactParamMethodMatcher(methods, cut.getClassName(), classesToMethods);
    }

    private static void validateMethod(Method m, String extName) {
        if (m == null) {
            throw new RuntimeException(MessageFormat.format("At least one method must be specified for each point cut in the extension {0}", extName));
        }
        String mName = m.getName();
        if (mName == null || mName.trim().length() == 0) {
            throw new RuntimeException(MessageFormat.format("A method name must be specified for each method in the extension {0}", extName));
        }
        MethodParameters mParams = m.getParameters();
        if (mParams == null) {
            mParams = new MethodParameters(new ArrayList<String>());
            m.setParameters(mParams);
        }
        if (mParams.isWasError()) {
            throw new RuntimeException(mParams.getErrorMessage());
        }
    }

    private static ClassMatcher createClassMatcher(String className, String pExtName) {
        ExtensionConversionUtility.verifyClassName(className, pExtName);
        return new ExactClassMatcher(className.trim());
    }

    private static void verifyClassName(String pClassName, String pName) {
        if (pClassName == null || pClassName.trim().length() == 0) {
            throw new RuntimeException(MessageFormat.format("A class name needs to be specified for every point cut in the extension {0}", pName));
        }
    }
}

